<?php
$fullname=$username=$email=$phone=$coupon=$password=$genMsg="";

if(isset($_POST['login'])){

    if(!empty($_POST['username'])){
        $username=$_POST['username'];
    }
    if(!empty($_POST['password'])){
        $password=$_POST['password'];
    }

    if(empty($_POST['username'])){
        $status="error";
        $message="Enter your username"; 
        $genMsg=sendResponse($status, $message);
    }
    else if(empty($_POST['password'])){
        $status="error";
        $message="Enter your password";
        $genMsg=sendResponse($status, $message);
    }
    else{
        $psw=sha1($password);
        $sql=$link->prepare("SELECT * FROM users WHERE username=? OR email=?");
        $sql->bind_param("ss", $username, $username);
        $sql->execute();
        $result=$sql->get_result();
        $numrow=$result->num_rows;
        $row=$result->fetch_assoc();
        if($numrow == 0){
            $status="error";
            $message="Incorrect username or password"; 
            $genMsg=sendResponse($status, $message);
        }
        else{
            $hashedPassword=$row['password'];
            $username=$row['username'];
            $role=$row['role'];
            $status=$row['status'];
            $time=$row['time'];
            $planType=$row['plantype'];
            if($planType == "plan_a"){
                $dailyLogin=$dailyLoginA;
            }
            else if($planType == "plan_b"){
                $dailyLogin=$dailyLoginB;
            }
            else if($planType == "plan_c"){
                $dailyLogin=$dailyLoginC;
            }
            if(!password_verify($psw, $hashedPassword)){
                $status="error";
                $message="Incorrect username or password";
                $genMsg=sendResponse($status, $message);
            }
            else if($status == "suspended"  && $role != "admin"){
                $status="error";
                $message="Your account has been suspended";
                $genMsg=sendResponse($status, $message);
            }
            else if(time() > $time && $role != "admin"){

                $sql=$link->prepare("UPDATE users SET status='expired' WHERE username=?");
                $sql->bind_param("s", $username);
                $sql->execute();

                $status="error";
                $message="Your account has expired, purchase another coupon to reactivate account";
                $genMsg=sendResponse($status, $message);
            }
            else{
                if(!empty($dailyLogin)){
                    $sql=$link->prepare("SELECT * FROM dailylogin WHERE username=? AND SUBSTRING(date,1,10) =?");
                    $sql->bind_param("ss", $username, $date);
                    $sql->execute();
                    $result=$sql->get_result();
                    $numrow=$result->num_rows;
                    $row=$result->fetch_assoc();
                    if($numrow == 0){
                        $sql=$link->prepare("UPDATE users SET funds=funds + ? WHERE username=?");
                        $sql->bind_param("ss", $dailyLogin, $username);
                        if($sql->execute()){
                            $sql=$link->prepare("INSERT INTO dailylogin(username,amount,date) VALUES(?,?,?)");
                            $sql->bind_param("sss", $username, $dailyLogin, $dateTime);
                            $sql->execute();
                        }
                    }
                }

                session_regenerate_id();
                $_SESSION['username']=$username;
                $_SESSION['role']=$role;
                session_write_close();

                

                if($role == "user" || $role == "vendor"){
                    header("location:user/index.php");
                }
                else if($role == "admin"){
                    header("location:user/admin/dashboard.php");
                }
            }
        }
    }
}


if(isset($_POST['signup'])){
    if(!empty($_POST['fullname'])){
        $fullname=$_POST['fullname'];
    }
    if(!empty($_POST['username'])){
        $username=$_POST['username'];
    }
    if(!empty($_POST['phoneNumber'])){
        $phone=$_POST['phoneNumber'];
    }
    if(!empty($_POST['refUsername'])){
        $refUsername=$_POST['refUsername'];
    }
    if(!empty($_POST['password'])){
        $password=$_POST['password'];
    }   

    if(empty($_POST['fullname'])){
        $status="error";
        $message="Enter your fullname"; 
        $genMsg=sendResponse($status, $message);
    }
    else if(empty($_POST['username'])){
        $status="error";
        $message="Enter a username";
        $genMsg=sendResponse($status, $message);
    }
    else if (!preg_match('/^[a-zA-Z]*$/', $_POST['username'])) {
        $status = "error";
        $message = "Username should not contain any spaces, characters or emojis ";
        $genMsg = sendResponse($status, $message);
    }
    else if (trim($_POST['username']) === '') {
        $status = "error";
        $message = "Your username should not be empty or contain any spaces or emojis";
        $genMsg = sendResponse($status, $message);
    }
    else if(strlen($_POST['username']) > 15){
        $status="error";
        $message="Username should be less than 15 characters";
        $genMsg=sendResponse($status, $message);
    }
    else if(empty($_POST['phoneNumber'])){
        $status="error";
        $message="Enter your phone number";
        $genMsg=sendResponse($status, $message);
    }
    else if(strlen($_POST['phoneNumber']) != 11){
        $status="error";
        $message="Invalid phone number";
        $genMsg=sendResponse($status, $message);
    }
    else if(empty($_POST['password'])){
        $status="error";
        $message="Enter a password";
        $genMsg=sendResponse($status, $message);
    }
    else if(strlen($_POST['password']) < 8){
        $status="error";
        $message="Password must be at least 8 characters";
        $genMsg=sendResponse($status, $message);
    }
    else{
        $fullname=filter_string($_POST['fullname']);
        $username=filter_string($_POST['username']);
        $phoneNumber=filter_string($_POST['phoneNumber']);
        $refUsername=filter_string($_POST['refUsername']);
        $password=filter_string($_POST['password']);

        $sql=$link->prepare("SELECT * FROM users WHERE username=?");
        $sql->bind_param("s", $username);
        $sql->execute();
        $result=$sql->get_result();
        $numrow_user=$result->num_rows;
        
        $sql=$link->prepare("SELECT * FROM users WHERE phone=?");
        $sql->bind_param("s", $phoneNumber);
        $sql->execute();
        $result=$sql->get_result();
        $numrow_phone=$result->num_rows;
        
        if($numrow_user > 0){
            $status="error";
            $message="Username already exist";
            $genMsg=sendResponse($status, $message);
        }
        else if($numrow_phone > 0){
            $status="error";
            $message="Phone number already in use";
            $genMsg=sendResponse($status, $message);
        } 
        else{
            $password=sha1($password);
            $password=password_hash($password, PASSWORD_DEFAULT);
            
            // Set default values for Flowcash
            $planType = "plan_a"; // Default plan
            $coupon = "FREE_SIGNUP"; // Default coupon
            $email = $username . "@flowcash.com"; // Generate default email
            $welcomeBonus = $welcomeBonusA; // Default welcome bonus
            $refBonus = $refBonusA; // Default referral bonus
            $indRef = $indRefA; // Default indirect referral bonus
            $thirdIndRef = $thirdIndRefA; // Default third indirect referral bonus
            $time = strtotime("+60 days", time()); // 60 days expiration
            
            // Process referral if provided
            if(!empty($refUsername)){
                $sql=$link->prepare("SELECT * FROM users WHERE username=?");
                $sql->bind_param("s", $refUsername);
                $sql->execute();
                $result=$sql->get_result();
                $numrow_refUser=$result->num_rows;
                
                if($numrow_refUser == 1){
                    $sql=$link->prepare("INSERT INTO referrals(username,referral,date) VALUES(?,?,?)");
                    $sql->bind_param("sss", $username, $refUsername, $dateTime);
                    if($sql->execute()){
                        // Add referral bonus to the referrer
                        $sql=$link->prepare("UPDATE users SET referralfunds=referralfunds + ?, totalrefearnings=totalrefearnings + ? WHERE username=?");
                        $sql->bind_param("sss", $refBonus, $refBonus, $refUsername);
                        $sql->execute();
                        
                        // Process multi-level referrals if applicable
                        $sql=$link->prepare("SELECT * FROM referrals WHERE username=?");
                        $sql->bind_param("s", $refUsername);
                        $sql->execute();
                        $result=$sql->get_result();
                        if($result->num_rows == 1){
                            $row=$result->fetch_assoc();
                            $thirdReferral=$row['referral'];
                            
                            if(!empty($thirdReferral)){
                                // Add bonus to third-level referrer
                                $sql=$link->prepare("UPDATE users SET thirdindrefunds=thirdindrefunds + ?, totalrefearnings=totalrefearnings + ? WHERE username=?");
                                $sql->bind_param("sss", $thirdIndRef, $thirdIndRef, $thirdReferral);
                                $sql->execute();
                                
                                // Add bonus to second-level referrer (indirect)
                                $sql=$link->prepare("UPDATE users SET indrefunds=indrefunds + ?, referralfunds=referralfunds + ?, totalrefearnings=totalrefearnings + ? WHERE username=?");
                                $sql->bind_param("ssss", $indRef, $indRef, $indRef, $refUsername);
                                $sql->execute();
                                
                                // Record indirect referral
                                $sql=$link->prepare("INSERT INTO indirectreferrals(username, thridreferral, indirectusername, referral, date) VALUES(?,?,?,?,?)");
                                $sql->bind_param("sssss", $username, $thirdReferral, $refUsername, $refUsername, $dateTime);
                                $sql->execute();
                            }
                        }
                    }
                }
            }
            
            // Insert new user
            $sql=$link->prepare("INSERT INTO users(fullname, username, email, phone, coupon, password, date, funds, plantype, time) VALUES(?,?,?,?,?,?,?,?,?,?)");
            $sql->bind_param("ssssssssss", $fullname, $username, $email, $phoneNumber, $coupon, $password, $dateTime, $welcomeBonus, $planType, $time);
            
            if($sql->execute()){
                echo "<script>setTimeout(()=>{location.href='$stream/login'}, 2000); </script>";
                $status="success";
                $message="Registration was successful, proceed to login"; 
                $genMsg=sendResponse($status, $message);
            }
            else{
                $status="error";
                $message="Something went wrong creating account";
                $genMsg=sendResponse($status, $message);
            }
        } 
    }
}
