<?php
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/actions/formprocess.php";
 $ptitle="Login";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="<?php echo $siteDesc ?>">
    <title><?php echo $ptitle . " - " . $sitename ?></title>
    <link rel="shortcut icon" href="g1.jpg">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        :root {
            /* Gainmart colors */
            --primary-blue: #75AFEE;
            --dark-blue: #4A8FE7;
            --darker-blue: #2E6CBF;
            --black: #000000;
            --dark-gray: #1A1A1A;
            --medium-gray: #2A2A2A;
            --light-gray: #3A3A3A;
            --text-light: #E0E0E0;
            --text-dim: #A0A0A0;
            --card-bg: #1F1F1F;
            --card-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
            --input-bg: #2A2A2A;
            --border-color: #3A3A3A;
            --success: #4CAF50;
            --warning: #FFC107;
            --danger: #F44336;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background-color: var(--black);
            color: var(--text-light);
            transition: all 0.3s ease;
            min-height: 100vh;
            padding-bottom: 5rem; /* Added padding for bottom nav */
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        h1,h2,h3,h4,h5,h6 {
            font-weight: 700;
        }

        .nk-app-root {
            width: 100%;
            max-width: 450px;
            padding: 20px;
        }

        .brand-logo {
            text-align: center;
            margin-bottom: 2rem;
        }

        .brand-logo img {
            filter: drop-shadow(0 0 8px rgba(117, 175, 238, 0.3));
            max-width: 120px;
        }

        .card-auth {
            background: var(--dark-gray);
            border-radius: 0.75rem;
            padding: 2rem;
            box-shadow: var(--card-shadow);
            margin-bottom: 2rem;
        }

        .nk-block-title {
            font-size: 1.75rem;
            font-weight: 700;
            color: var(--text-light);
            margin-bottom: 0.5rem;
            text-align: center;
        }

        .nk-block-head-content {
            text-align: center;
            margin-bottom: 1.5rem;
        }

        .nk-block-head-content p {
            color: var(--text-dim);
            margin-bottom: 1rem;
        }

        .form-label {
            display: block;
            font-weight: 500;
            margin-bottom: 0.5rem;
            color: var(--text-light);
        }

        .form-control {
            width: 100%;
            background: var(--input-bg);
            border: 1px solid var(--border-color);
            border-radius: 0.5rem;
            padding: 0.75rem;
            color: var(--text-light);
            font-size: 1rem;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            border-color: var(--primary-blue);
            box-shadow: 0 0 0 0.25rem rgba(117, 175, 238, 0.25);
            outline: none;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .btn-primary {
            background: var(--primary-blue);
            color: var(--black);
            border: none;
            border-radius: 0.5rem;
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            width: 100%;
            font-size: 1rem;
        }

        .btn-primary:hover {
            background: var(--dark-blue);
            transform: translateY(-2px);
        }

        .d-flex {
            display: flex;
        }

        .flex-wrap {
            flex-wrap: wrap;
        }

        .justify-content-between {
            justify-content: space-between;
        }

        .d-grid {
            display: grid;
        }

        .row {
            display: flex;
            flex-wrap: wrap;
            margin: 0 -0.75rem;
        }

        .gy-3 > * {
            margin-top: 1rem;
            margin-bottom: 1rem;
        }

        .col-12 {
            flex: 0 0 100%;
            max-width: 100%;
            padding: 0 0.75rem;
        }

        a {
            color: var(--primary-blue);
            text-decoration: none;
            transition: all 0.3s ease;
        }

        a:hover {
            color: var(--dark-blue);
            text-decoration: underline;
        }

        .small {
            font-size: 0.875rem;
            color: var(--text-dim);
        }

        .text-center {
            text-align: center;
        }

        .text-center p {
            margin-top: 1.5rem;
            padding-top: 1.5rem;
            border-top: 1px solid var(--border-color);
        }

        /* Bottom Navigation Menu */
        .bottom-menu {
            position: fixed;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            width: 90%;
            max-width: 500px;
            background-color: var(--dark-gray);
            border-radius: 20px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
            display: flex;
            justify-content: space-around;
            align-items: center;
            padding: 12px 7px;
            z-index: 1000;
            backdrop-filter: blur(10px);
        }

        .menu-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-decoration: none;
            color: var(--text-dim);
            border-radius: 10px;
            transition: all 0.3s ease;
            padding: 6px 12px;
            background-color: transparent;
        }

        .menu-item:hover, .menu-item.active {
            background-color: var(--medium-gray);
            color: var(--primary-blue);
        }

        .menu-item i {
            font-size: 1.2rem;
            margin-bottom: 3px;
        }

        .menu-item span {
            font-size: 0.7rem;
            font-weight: 500;
        }

        /* Responsive Styles */
        @media (max-width: 576px) {
            .card-auth {
                padding: 1.5rem;
            }
            
            .nk-block-title {
                font-size: 1.5rem;
            }
            
            .bottom-menu {
                width: 95%;
                padding: 10px 5px;
            }
            
            .menu-item i {
                font-size: 1.1rem;
            }
            
            .menu-item span {
                font-size: 0.65rem;
            }
        }
    </style>
</head>
<body class="nk-body" data-sidebar-collapse="lg" data-navbar-collapse="lg">
    <div class="nk-app-root">
        <div class="brand-logo">
            <a href="/" class="logo-link">
                <div class="logo-wrap">
                    <img src="g1.jpg" width="120">
                </div>
            </a>
        </div>
        <div class="card card-gutter-lg rounded-4 card-auth">
            <div class="card-body px-3">
                <div class="nk-block-head">
                    <div class="nk-block-head-content">
                        <h3 class="nk-block-title mb-1">Sign in to Account</h3>
                        <p class="small">Please sign-in your account and start the adventure.</p>
                        <?php echo $genMsg ?>
                    </div>
                </div>
                <form method="post">
                    <div class="row gy-3">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="username" class="form-label">Username</label>
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" name="username" value="<?php echo $username?>" placeholder="Enter username">
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="password" class="form-label">Password</label>
                                <div class="form-control-wrap">
                                    <input type="password" class="form-control" name="password" placeholder="Enter password">
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="d-flex flex-wrap justify-content-between">
                                <a href="forgot-pass" class="small">Forgot Password?</a>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="d-grid">
                                <button class="btn btn-primary" name="login" type="submit">Login Account</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="text-center">
            <p class="small">Don't have an account? <a href="register">Register</a></p>
        </div>
    </div>

    <!-- Bottom Navigation Menu -->
    <div class="bottom-menu">
        <a href="index.html" class="menu-item">
            <i class="fas fa-home"></i>
            <span>Home</span>
        </a>
        <a href="login" class="menu-item active">
            <i class="fas fa-sign-in-alt"></i>
            <span>Login</span>
        </a>
        <a href="register" class="menu-item">
            <i class="fas fa-user-plus"></i>
            <span>Sign Up</span>
        </a>
       
    </div>

    <script src="../assets/js/bundle.js"></script>
    <script src="../assets/js/scripts.js"></script>
</body>
</html>