<?php
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/user/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/topup.php";


if(isset($_POST['buyAirtime']) && !empty($_POST['buyAirtime'])){
    $networks=array("mtn","airtel","9mobile","glo");
    
    $sql=$link->prepare("SELECT * FROM topup WHERE username=? AND date=? AND type='airtime'");
    $sql->bind_param("ss", $username, $dateTime);
    $sql->execute();
    $result=$sql->get_result();
    $numrowAirtime=$result->num_rows;
    
    $amount=filter_string($_POST['amount']);
    
    if($amount =="200"){
        $deductAmt="6000";
    }
    else if($amount =="400"){
        $deductAmt="12000";
    }
        
    if(empty($_POST['amount'])){
        $status="error";
        $message="Enter an amount";
        echo sendResponse($status, $message);
    }
    else if(!is_numeric($_POST['amount'])){
        $status="error";
        $message="Enter a valid amount";
        echo sendResponse($status, $message);
    }
    else if($_POST['amount'] < 100){
        $status="error";
        $message="Amount must be greater or equal to NGN100";
        echo sendResponse($status, $message);
    }
    else if(empty($_POST['network'])){
        $status="error";
        $message="Select your network";
        echo sendResponse($status, $message);
    }
    else if(empty($_POST['phone'])){
        $status="error";
        $message="Enter a phone number";
        echo sendResponse($status, $message);
    }
    else if(!is_numeric($_POST['phone'])){
        $status="error";
        $message="Enter a valid phone number";
        echo sendResponse($status, $message);
    }
    else if(strlen($_POST['phone']) != 11){
        $status="error";
        $message="Enter a valid phone number";
        echo sendResponse($status, $message);
    }
    else if(!in_array($_POST['network'], $networks)){
        $status="error";
        $message="Invalid network";
        echo sendResponse($status, $message);
    }
    else if($_POST['amount'] && $deductAmt > $funds){
        $status="error";
        $message="Insuffucient funds";
        echo sendResponse($status, $message);
    }
   /* else if($numrowAirtime == 1 && $numrowAirtime >= 0){
        $status="error";
        $message="You have bought airtime today already, wait for tomorrow";
        echo sendResponse($status, $message);
    } */
    else{
        $amount=filter_string($_POST['amount']);
        $network=filter_string($_POST['network']);
        $phone=filter_string($_POST['phone']);
        if($network == "mtn"){
            $serviceID=100;
        }
        else if($network == "glo"){
            $serviceID=200;
        }
        else if($network == "airtel"){
            $serviceID=300;
        }
        else if($network == "9mobile"){
            $serviceID=400;
        }
        
        switch($amount){
            case '200':
                $deductAmt=6000;
                break;
            case '400':
                $deductAmt=12000;
                break;
        }
        //$deductAmt=$amount;
        $sql=$link->prepare("UPDATE users SET funds=funds - ? WHERE username=?");
        $sql->bind_param("ss", $deductAmt, $username);
        if($sql->execute()){
            $data=array("serviceID" => $serviceID, "amount" => $amount, "phone" => $phone);
            $buyAirtime=buyAirtime($data);
            $airtimeStatus=$airtimeMessage="";
            if(isset($buyAirtime['status'])){
                $airtimeStatus=$buyAirtime['status'];
                $airtimeMessage=$buyAirtime['message'];
            }
    
            $type="airtime";
            $desc=$phone;
            $status="successful";
            if($airtimeStatus == "success"){
                $reference=$buyAirtime['data']['reference'];
                $amountPaid=$buyAirtime['data']['amountPaid'];
                $sql=$link->prepare("INSERT INTO topup(username,type,reference,network,amount,amountpaid,phone,date) VALUES(?,?,?,?,?,?,?,?)");
                $sql->bind_param("ssssssss", $username, $type, $reference, $network, $amount, $amountPaid, $phone, $date);
                if($sql->execute()){
                    $sql=$link->prepare("INSERT INTO withdrawals(username,type,amount,description,status,network,date) VALUES(?,?,?,?,?,?,?)");
                    $sql->bind_param("sssssss", $username, $type, $amount, $desc, $status, $network, $dateTime);
                    $sql->execute();

                    $status="success";
                    $message="Airtime purchase successful";
                    echo sendResponse($status, $message);
                }
                else{
                    $status="error";
                    $message="Something went wrong";
                    echo sendResponse($status, $message);
                }
            }
            else{
                $sql=$link->prepare("UPDATE users SET funds=funds + ? WHERE username=?");
                $sql->bind_param("ss", $deductAmt, $username);
                if($sql->execute()){
                    $status="error";
                    $message="Could not buy airtime at this time, try again later";
                    echo sendResponse($status, $message);
                }
            }
        }
        else{
            $status="error";
            $message="Something went wrong";
            echo sendResponse($status, $message);
        }
    }
}

if(isset($_POST['buyData']) && !empty($_POST['buyData'])){
    $networks=array("mtn","airtel","9mobile","glo");
    if(empty($_POST['serviceID'])){
        $status="error";
        $message="Select dataplan";
        echo sendResponse($status, $message);
    }
    else if(!is_numeric($_POST['serviceID'])){
        $status="error";
        $message="Select dataplan";
        echo sendResponse($status, $message);
    }
    else if(empty($_POST['network'])){
        $status="error";
        $message="Select your network";
        echo sendResponse($status, $message);
    }
    else if(empty($_POST['phone'])){
        $status="error";
        $message="Enter a phone number";
        echo sendResponse($status, $message);
    }
    else if(!is_numeric($_POST['phone'])){
        $status="error";
        $message="Enter a valid phone number";
        echo sendResponse($status, $message);
    }
    else if(strlen($_POST['phone']) != 11){
        $status="error";
        $message="Enter a valid phone number";
        echo sendResponse($status, $message);
    }
    else if(!in_array($_POST['network'], $networks)){
        $status="error";
        $message="Invalid network";
        echo sendResponse($status, $message);
    }
    else{
        $serviceID=filter_string($_POST['serviceID']);
        $network=filter_string($_POST['network']);
        $phone=filter_string($_POST['phone']);

        $sql=$link->prepare("SELECT * FROM dataprices WHERE serviceid=?");
        $sql->bind_param("s", $serviceID);
        $sql->execute();
        $result=$sql->get_result();
        $numrow=$result->num_rows;
        $row=$result->fetch_assoc();
        if($numrow == 0){
            $status="error";
            $message="Something went wrong validating data";
            echo sendResponse($status, $message);
            exit;
        }
        $amount=$row['amount'];
        if($amount > $funds){
            $status="error";
            $message="Insuffucient funds";
            echo sendResponse($status, $message);
            exit;
        }
        $sql=$link->prepare("UPDATE users SET funds=funds - ? WHERE username=?");
        $sql->bind_param("ss", $amount, $username);
        if($sql->execute()){
            $data=array("serviceID" => $serviceID, "phone" => $phone);
            $buyData=buyData($data);
            $dataStatus=$dataMessage="";
            if(isset($buyData['status'])){
                $dataStatus=$buyData['status'];
                $dataMessage=$buyData['message'];
            }
    
            $type="data";
            $desc=$phone;
            $status="successful";
            if($dataStatus == "success"){
                $reference=$buyData['data']['reference'];
                $amountPaid=$buyData['data']['amount'];
                $sql=$link->prepare("INSERT INTO topup(username,type,reference,network,amount,amountpaid,phone,date) VALUES(?,?,?,?,?,?,?,?)");
                $sql->bind_param("ssssssss", $username, $type, $reference, $network, $amount, $amountPaid, $phone, $date);
                if($sql->execute()){
                    $sql=$link->prepare("INSERT INTO withdrawals(username,type,amount,description,status,network,date) VALUES(?,?,?,?,?,?,?)");
                    $sql->bind_param("sssssss", $username, $type, $amount, $desc, $status, $network, $dateTime);
                    $sql->execute();

                    $status="success";
                    $message="Data purchase successful";
                    echo sendResponse($status, $message);
                }
                else{
                    $status="error";
                    $message="Something went wrong";
                    echo sendResponse($status, $message);
                }
            }
            else{
                $sql=$link->prepare("UPDATE users SET funds=funds + ? WHERE username=?");
                $sql->bind_param("ss", $amount, $username);
                if($sql->execute()){
                    $status="error";
                    $message="Could not buy data at this time, try again later";
                    echo sendResponse($status, $message);
                }
            }
        }
        else{
            $status="error";
            $message="Something went wrong";
            echo sendResponse($status, $message);
        }
    }
}
?>