<?php
$fullnameErr=$phoneErr=$bankErr=$acctNameErr=$acctNumErr=$igErr=$twErr=$ytErr=$fbErr=$profileMsg=$passwordMsg=$currPswErr=$newPswErr=$confirmPswErr=$currPsw=$newPsw=$confirmPsw="";
if(isset($_POST['updateProfile'])){

    if(!empty($_POST['fullname'])){
        $fullname=$_POST['fullname'];
    }
    if(!empty($_POST['phone'])){
        $phoneNumber=$_POST['phone'];
    }
    if(!empty($_POST['bankName'])){
        $bankName=$_POST['bankName'];
    }
    if(!empty($_POST['acctName'])){
        $acctName=$_POST['acctName'];
    }
    if(!empty($_POST['acctNum'])){
        $acctNum=$_POST['acctNum'];
    }
    if(!empty($_POST['fbLink'])){
        $fbLink=$_POST['fbLink'];
    }   
    if(!empty($_POST['igLink'])){
        $igLink=$_POST['igLink'];
    }
    if(!empty($_POST['ytLink'])){
        $ytLink=$_POST['ytLink'];
    }
    if(!empty($_POST['twLink'])){
        $twLink=$_POST['twLink'];
    }   


    if(empty($_POST['fullname'])){
        $status="error";
        $message="Enter your fullname"; 
        $fullnameErr=sendResponse($status, $message);
    }
    else if(empty($_POST['phone'])){
        $status="error";
        $message="Enter your phone number";
        $phoneErr=sendResponse($status, $message);
    }
    else if(strlen($_POST['phone']) != 11){
        $status="error";
        $message="Invalid phone number";
        $phoneErr=sendResponse($status, $message);
    }
    else if(empty($_POST['bankName'])){
        $status="error";
        $message="Enter your bank name";
        $bankErr=sendResponse($status, $message);
    }
    else if(empty($_POST['acctName'])){
        $status="error";
        $message="Enter your account name";
        $acctNameErr=sendResponse($status, $message);
    }
    else if(empty($_POST['acctNum'])){
        $status="error";
        $message="Enter your account number";
        $acctNumErr=sendResponse($status, $message);
    }
    else if(strlen($_POST['acctNum']) != 10){
        $status="error";
        $message="Invalid account number";
        $acctNumErr=sendResponse($status, $message);
    }
    else if(empty($_POST['fbLink'])){
        $status="error";
        $message="Enter your facebook profile link";
        $fbErr=sendResponse($status, $message);
    }
    else if(empty($_POST['twLink'])){
        $status="error";
        $message="Enter your twitter link";
        $twErr=sendResponse($status, $message);
    }
    else if(empty($_POST['igLink'])){
        $status="error";
        $message="Enter your instagram link";
        $igErr=sendResponse($status, $message);
    }
    else if(empty($_POST['ytLink'])){
        $status="error";
        $message="Enter your youtube link";
        $ytErr=sendResponse($status, $message);
    }
    else{
        $fullname=filter_string($_POST['fullname']);
        $phone=filter_string($_POST['phone']);
        $bankName=filter_string($_POST['bankName']);
        $acctName=filter_string($_POST['acctName']);
        $acctNum=filter_string($_POST['acctNum']);
        $fbLink=filter_string($_POST['fbLink']);
        $twLink=filter_string($_POST['twLink']);
        $igLink=filter_string($_POST['igLink']);
        $ytLink=filter_string($_POST['ytLink']);

        $sql=$link->prepare("SELECT * FROM bankaccounts WHERE username=?");
        $sql->bind_param("s", $username);
        $sql->execute();
        $result=$sql->get_result();
        $numrow=$result->num_rows;

        if($numrow == 0){
            $sql=$link->prepare("INSERT INTO bankaccounts(username, bankname, acctname, acctnum, date) VALUES(?,?,?,?,?)");
            $sql->bind_param("sssss", $username, $bankName, $acctName, $acctNum, $dateTime);
        }
        else{
            $sql=$link->prepare("UPDATE bankaccounts SET  bankname=?, acctname=?, acctnum=? WHERE username=?");
            $sql->bind_param("ssss", $bankName, $acctName, $acctNum, $username);
        }
        $sql->execute();


        $sql=$link->prepare("SELECT * FROM profilelinks WHERE username=?");
        $sql->bind_param("s", $username);
        $sql->execute();
        $result=$sql->get_result();
        $numrow=$result->num_rows;

        if($numrow == 0){
            $sql=$link->prepare("INSERT INTO profilelinks(username, type, url, date) VALUES(?,?,?,?)");
            $sql->bind_param("ssss", $username, $type, $url, $dateTime);

            $type="facebook";
            $url=$fbLink;
            $sql->execute();
            $type="twitter";
            $url=$twLink;
            $sql->execute();
            $type="youtube";
            $url=$ytLink;
            $sql->execute();
            $type="instagram";
            $url=$igLink;
            $sql->execute();
        }
        else{
            $sql=$link->prepare("UPDATE profilelinks SET url=? WHERE username=? AND type=?");
            $sql->bind_param("sss", $url, $username, $type);

            $type="facebook";
            $url=$fbLink;
            $sql->execute();
            $type="twitter";
            $url=$twLink;
            $sql->execute();
            $type="youtube";
            $url=$ytLink;
            $sql->execute();
            $type="instagram";
            $url=$igLink;
            $sql->execute();
        }
        

        $sql=$link->prepare("UPDATE users SET fullname=?, phone=? WHERE username=?");
        $sql->bind_param("sss", $fullname, $phone, $username);
        if($sql->execute()){
            $status="success";
            $message="Details has been saved";
            $profileMsg=sendResponse($status, $message);
        }
        else{
            $status="error";
            $message="Failed to save details";
            $profileMsg=sendResponse($status, $message);
        }

    }
} 


if(isset($_POST['updatePsw'])){

    if(!empty($_POST['currPsw'])){
        $currPsw=$_POST['currPsw'];
    }
    if(!empty($_POST['newPsw'])){
        $newPsw=$_POST['newPsw'];
    }
    if(!empty($_POST['confirmPsw'])){
        $confirmPsw=$_POST['confirmPsw'];
    }  


    if(empty($_POST['currPsw'])){
        $status="error";
        $message="Enter your current password"; 
        $currPswErr=sendResponse($status, $message);
    }
    else if(empty($_POST['newPsw'])){
        $status="error";
        $message="Enter your new password";
        $newPswErr=sendResponse($status, $message);
    }
    else if(strlen($_POST['newPsw']) < 8){
        $status="error";
        $message="Password must be at least 8 characters";
        $newPswErr=sendResponse($status, $message);
    }
    else if(empty($_POST['confirmPsw'])){
        $status="error";
        $message="Confirm your password";
        $confirmPswErr=sendResponse($status, $message);
    }
    else if($_POST['newPsw'] != $_POST['confirmPsw']){
        $status="error";
        $message="Passwords does not match";
        $confirmPswErr=sendResponse($status, $message);
    }
    else{
        $currPsw=filter_string($_POST['currPsw']);
        $password=sha1($currPsw);

    
        if(!password_verify($password, $hashedPassword)){
            $status="error";
            $message="Current password is incorrect";
            $currPswErr=sendResponse($status, $message);   
        }
        else{
            $newPsw=filter_string($_POST['newPsw']);
            $password=sha1($newPsw);
            
            $password=password_hash($password, PASSWORD_DEFAULT);
            $sql=$link->prepare("UPDATE users SET password=? WHERE username=?");
            $sql->bind_param("ss", $password, $username);
            if($sql->execute()){
                $status="success";
                $message="Password has been updated";
                $profileMsg=sendResponse($status, $message);
            }
            else{
                $status="error";
                $message="Failed to update password";
                $profileMsg=sendResponse($status, $message);
            }        
        }
    }
}
?>