<?php
$userMsg="";

if(isset($_POST['makeVendor'])){
    if(empty($_POST['username'])){
        $status="error";
        $message="Something went wrong"; 
        $userMsg=sendResponse($status, $message);
    }
    else{
        $username=filter_string($_POST['username']);
        $sql=$link->prepare("UPDATE users SET role='vendor' WHERE username=?");
        $sql->bind_param("s", $username);
        if($sql->execute()){
            $status="success";
            $message="User changed to vendor"; 
            $userMsg=sendResponse($status, $message);
        }
        else{
            $status="error";
            $message="Something went wrong"; 
            $userMsg=sendResponse($status, $message);
        }
    }
}

if(isset($_POST['removeVendor'])){
    if(empty($_POST['username'])){
        $status="error";
        $message="Something went wrong"; 
        $userMsg=sendResponse($status, $message);
    }
    else{
        $username=filter_string($_POST['username']);
        $sql=$link->prepare("UPDATE users SET role='user' WHERE username=?");
        $sql->bind_param("s", $username);
        if($sql->execute()){
            $status="success";
            $message="Vendor removed"; 
            $userMsg=sendResponse($status, $message);
        }
        else{
            $status="error";
            $message="Something went wrong"; 
            $userMsg=sendResponse($status, $message);
        }
    }
}

if(isset($_POST['suspend'])){
    if(empty($_POST['username'])){
        $status="error";
        $message="Something went wrong"; 
        $userMsg=sendResponse($status, $message);
    }
    else{
        $username=filter_string($_POST['username']);
        $sql=$link->prepare("UPDATE users SET status='suspended' WHERE username=?");
        $sql->bind_param("s", $username);
        if($sql->execute()){
            $status="success";
            $message="User suspended"; 
            $userMsg=sendResponse($status, $message);
        }
        else{
            $status="error";
            $message="Something went wrong"; 
            $userMsg=sendResponse($status, $message);
        }
    }
}

if(isset($_POST['activate'])){
    if(empty($_POST['username'])){
        $status="error";
        $message="Something went wrong"; 
        $userMsg=sendResponse($status, $message);
    }
    else{
        $username=filter_string($_POST['username']);
        $sql=$link->prepare("UPDATE users SET status='active' WHERE username=?");
        $sql->bind_param("s", $username);
        if($sql->execute()){
            $status="success";
            $message="User activated"; 
            $userMsg=sendResponse($status, $message);
        }
        else{
            $status="error";
            $message="Something went wrong"; 
            $userMsg=sendResponse($status, $message);
        }
    }
}

if(isset($_POST['sendCoupon'])){
    if(empty($_POST['username'])){
        $status="error";
        $message="Something went wrong"; 
        $userMsg=sendResponse($status, $message);
    }
    else{
        $username=filter_string($_POST['username']);
        $coupon=strtoupper(get_rand_alphanumeric(12));
        $sql=$link->prepare("INSERT INTO coupons(coupon,vendor,date) VALUES(?,?,?)");
        $sql->bind_param("sss", $coupon, $username, $dateTime);
        if($sql->execute()){
            $status="success";
            $message="Coupon sent to $username coupon: <strong>$coupon</strong>"; 
            $userMsg=sendResponse($status, $message);
        }
        else{
            $status="error";
            $message="Something went wrong"; 
            $userMsg=sendResponse($status, $message);
        }
    }
}


if(isset($_POST['deleteCoupon'])){
    if(empty($_POST['id'])){
        $status="error";
        $message="Something went wrong"; 
        $userMsg=sendResponse($status, $message);
    }
    else{
        $coupon=filter_string($_POST['id']);
        $sql=$link->prepare("DELETE FROM coupons WHERE coupon=?");
        $sql->bind_param("s", $coupon);
        if($sql->execute()){
            $status="success";
            $message="Coupon deleted"; 
            $userMsg=sendResponse($status, $message);
        }
        else{
            $status="error";
            $message="Something went wrong"; 
            $userMsg=sendResponse($status, $message);
        }
    }
}

if(isset($_POST['generateCoupon'])){
    if(empty($_POST['vendor'])){
        $status="error";
        $message="Select a vendor"; 
        $genMsg=sendResponse($status, $message);
    }
    else if(empty($_POST['plan'])){
        $status="error";
        $message="Select a plan"; 
        $genMsg=sendResponse($status, $message);
    }
    else if(empty($_POST['couponNum'])){
        $status="error";
        $message="Enter coupon quantity"; 
        $genMsg=sendResponse($status, $message);
    }
    else if(!is_numeric($_POST['couponNum'])){
        $status="error";
        $message="Enter a valid coupon number"; 
        $genMsg=sendResponse($status, $message);
    }
    else if($_POST['couponNum'] < 0){
        $status="error";
        $message="Coupon quantity must be greater than 0"; 
        $genMsg=sendResponse($status, $message);
    }
    else{
        $vendor=filter_string($_POST['vendor']);
        $plan=filter_string($_POST['plan']);
        $couponNum=filter_string($_POST['couponNum']);
        switch($plan){
            case "plan_a" : $suff="IGNITE-FREE"; break; 
            case "plan_b" : $suff="IGNITE-PAID"; break; 
            case "plan_c" : $suff="STUDENT"; break;
            case "plan_d" : $suff="SILIVER"; break; 
            case "plan_e" : $suff="TITAN"; break; 
            case "plan_f" : $suff="EXECLUSIVE"; break;
        }
        $coupons="";
        //$suff="X-G";
        for($i=1; $i <= $couponNum; $i++){
            $coupon=$suff.strtoupper(get_rand_alphanumeric(12));
            $sql=$link->prepare("INSERT INTO coupons(coupon,vendor,type,date) VALUES(?,?,?,?)");
            $sql->bind_param("ssss", $coupon, $vendor, $plan, $dateTime);
            $sql->execute();
            $coupons.="$coupon <br>";
        }
        $status="success";
        $message="Coupons generated. Coupons:<br><strong>$coupons</strong>"; 
        $genMsg=sendResponse($status, $message);
    }
}
?>