<?php
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/user/admin/includes/generalinclude.php";

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if flow_packages table exists, create if not
 $tableCheck = $link->query("SHOW TABLES LIKE 'flow_packages'");
if ($tableCheck->num_rows == 0) {
    $createTable = "CREATE TABLE `flow_packages` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `name` varchar(100) NOT NULL,
        `amount` decimal(10,2) NOT NULL,
        `daily_income` decimal(10,2) NOT NULL,
        `min_withdrawal` decimal(10,2) NOT NULL,
        `duration` int(11) NOT NULL,
        `total_income` decimal(10,2) GENERATED ALWAYS AS (daily_income * duration) STORED,
        `referral_bonus` decimal(10,2) NOT NULL,
        `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    if ($link->query($createTable)) {
        $pkgMsg = '<div class="alert alert-info">Packages table created successfully!</div>';
    } else {
        die("Error creating packages table: " . $link->error);
    }
}

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Add new package
    if (isset($_POST['addPackage'])) {
        try {
            $name = $_POST['name'];
            $amount = $_POST['amount'];
            $daily_income = $_POST['daily_income'];
            $min_withdrawal = $_POST['min_withdrawal'];
            $duration = $_POST['duration'];
            $referral_bonus = $_POST['referral_bonus'];
            
            $stmt = $link->prepare("INSERT INTO flow_packages (name, amount, daily_income, min_withdrawal, duration, referral_bonus) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("sdddid", $name, $amount, $daily_income, $min_withdrawal, $duration, $referral_bonus);
            
            if ($stmt->execute()) {
                $pkgMsg = '<div class="alert alert-success">Package added successfully!</div>';
            } else {
                throw new Exception("Database error: " . $stmt->error);
            }
        } catch (Exception $e) {
            $pkgMsg = '<div class="alert alert-danger">Error adding package: ' . $e->getMessage() . '</div>';
        }
    }
    
    // Delete package
    if (isset($_POST['deletePackage'])) {
        try {
            $pkgId = $_POST['pkgId'];
            
            $stmt = $link->prepare("DELETE FROM flow_packages WHERE id = ?");
            $stmt->bind_param("i", $pkgId);
            
            if ($stmt->execute()) {
                $pkgMsg = '<div class="alert alert-success">Package deleted successfully!</div>';
            } else {
                throw new Exception("Database error: " . $stmt->error);
            }
        } catch (Exception $e) {
            $pkgMsg = '<div class="alert alert-danger">Error deleting package: ' . $e->getMessage() . '</div>';
        }
    }
    
    // Edit package
    if (isset($_POST['editPackage'])) {
        try {
            $pkgId = $_POST['pkgId'];
            $name = $_POST['name'];
            $amount = $_POST['amount'];
            $daily_income = $_POST['daily_income'];
            $min_withdrawal = $_POST['min_withdrawal'];
            $duration = $_POST['duration'];
            $referral_bonus = $_POST['referral_bonus'];
            
            $stmt = $link->prepare("UPDATE flow_packages SET name = ?, amount = ?, daily_income = ?, min_withdrawal = ?, duration = ?, referral_bonus = ? WHERE id = ?");
            $stmt->bind_param("sdddidi", $name, $amount, $daily_income, $min_withdrawal, $duration, $referral_bonus, $pkgId);
            
            if ($stmt->execute()) {
                $pkgMsg = '<div class="alert alert-success">Package updated successfully!</div>';
            } else {
                throw new Exception("Database error: " . $stmt->error);
            }
        } catch (Exception $e) {
            $pkgMsg = '<div class="alert alert-danger">Error updating package: ' . $e->getMessage() . '</div>';
        }
    }
}

include "inc/header.php";
?>

<div class="container-fluid">
    <div class="layout-specing">
        <div class="d-md-flex justify-content-between align-items-center">
            <h5 class="mb-0">Package Management</h5>
            <nav aria-label="breadcrumb" class="d-inline-block mt-2 mt-sm-0">
                <ul class="breadcrumb bg-transparent rounded mb-0 p-0">
                    <li class="breadcrumb-item text-capitalize"><a href="dashboard">Dashboard</a></li>
                    <li class="breadcrumb-item text-capitalize active" aria-current="page">Packages</li>
                </ul>
            </nav>
        </div>
        
        <?php if (isset($pkgMsg)) echo $pkgMsg; ?>
        
        <!-- Add Package Form -->
        <div class="card border-0 rounded shadow mt-4">
            <div class="card-body">
                <h5 class="text-md-start text-center mb-0">Add New Package</h5>
                
                <form method="POST">
                    <div class="row mt-4">
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Package Name</label>
                                <div class="form-icon position-relative">
                                    <i data-feather="tag" class="fea icon-sm icons"></i>
                                    <input type="text" class="form-control ps-5" placeholder="Package Name" name="name" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Amount (₦)</label>
                                <div class="form-icon position-relative">
                                    <i data-feather="dollar-sign" class="fea icon-sm icons"></i>
                                    <input type="number" class="form-control ps-5" placeholder="Amount" name="amount" min="1" step="0.01" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Daily Income (₦)</label>
                                <div class="form-icon position-relative">
                                    <i data-feather="trending-up" class="fea icon-sm icons"></i>
                                    <input type="number" class="form-control ps-5" placeholder="Daily Income" name="daily_income" min="0.01" step="0.01" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Duration (days)</label>
                                <div class="form-icon position-relative">
                                    <i data-feather="calendar" class="fea icon-sm icons"></i>
                                    <input type="number" class="form-control ps-5" placeholder="Duration" name="duration" min="1" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Minimum Withdrawal (₦)</label>
                                <div class="form-icon position-relative">
                                    <i data-feather="minimize-2" class="fea icon-sm icons"></i>
                                    <input type="number" class="form-control ps-5" placeholder="Min Withdrawal" name="min_withdrawal" min="0" step="0.01" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Referral Bonus (₦)</label>
                                <div class="form-icon position-relative">
                                    <i data-feather="users" class="fea icon-sm icons"></i>
                                    <input type="number" class="form-control ps-5" placeholder="Referral Bonus" name="referral_bonus" min="0" step="0.01" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-sm-12">
                            <input type="submit" name="addPackage" class="btn btn-primary" value="Add Package">
                        </div>
                    </div>
                </form>
            </div>
        </div>
        
        <!-- Packages Table -->
        <div class="col mt-4 pt-2">
            <div class="component-wrapper rounded shadow">
                <div class="p-4 border-bottom">
                    <h4 class="title mb-0">Existing Packages</h4>
                </div>
                
                <div class="p-4">
                    <div class="table-responsive bg-white shadow rounded">
                        <table class="table mb-0 table-center">
                            <thead>
                                <tr>
                                    <th scope="col" class="border-bottom">#</th>
                                    <th scope="col" class="border-bottom">Name</th>
                                    <th scope="col" class="border-bottom">Amount</th>
                                    <th scope="col" class="border-bottom">Daily Income</th>
                                    <th scope="col" class="border-bottom">Duration</th>
                                    <th scope="col" class="border-bottom">Total Income</th>
                                    <th scope="col" class="border-bottom">Min Withdrawal</th>
                                    <th scope="col" class="border-bottom">Referral Bonus</th>
                                    <th scope="col" class="border-bottom">Created</th>
                                    <th scope="col" class="border-bottom">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                try {
                                    $sql = $link->prepare("SELECT * FROM flow_packages ORDER BY id DESC");
                                    $sql->execute();
                                    $result = $sql->get_result();
                                    
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $id = $row['id'];
                                            $name = $row['name'];
                                            $amount = $row['amount'];
                                            $daily_income = $row['daily_income'];
                                            $duration = $row['duration'];
                                            $total_income = $row['total_income'];
                                            $min_withdrawal = $row['min_withdrawal'];
                                            $referral_bonus = $row['referral_bonus'];
                                            $created_at = date('M j, Y', strtotime($row['created_at']));
                                    ?>
                                            <tr>
                                                <th scope="row"><?php echo $id ?></th>
                                                <td><?php echo $name ?></td>
                                                <td>₦<?php echo number_format($amount, 2) ?></td>
                                                <td>₦<?php echo number_format($daily_income, 2) ?></td>
                                                <td><?php echo $duration ?> days</td>
                                                <td>₦<?php echo number_format($total_income, 2) ?></td>
                                                <td>₦<?php echo number_format($min_withdrawal, 2) ?></td>
                                                <td>₦<?php echo number_format($referral_bonus, 2) ?></td>
                                                <td><?php echo $created_at ?></td>
                                                <td>
                                                    <div class="d-flex gap-2 flex-wrap">
                                                        <!-- Edit Package Button -->
                                                        <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editPackageModal<?php echo $id ?>">
                                                            <i class="fas fa-edit"></i> Edit
                                                        </button>
                                                        
                                                        <!-- Delete Button -->
                                                        <form method="post" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this package?')">
                                                            <input type="hidden" name="pkgId" value="<?php echo $id ?>">
                                                            <button type="submit" name="deletePackage" class="btn btn-sm btn-danger">
                                                                <i class="fas fa-trash"></i> Delete
                                                            </button>
                                                        </form>
                                                    </div>
                                                    
                                                    <!-- Edit Package Modal -->
                                                    <div class="modal fade" id="editPackageModal<?php echo $id ?>" tabindex="-1" aria-labelledby="editPackageModalLabel<?php echo $id ?>" aria-hidden="true">
                                                        <div class="modal-dialog modal-lg">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title" id="editPackageModalLabel<?php echo $id ?>">Edit Package</h5>
                                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <form method="POST">
                                                                        <input type="hidden" name="pkgId" value="<?php echo $id ?>">
                                                                        
                                                                        <div class="row">
                                                                            <div class="col-lg-6 col-12">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Package Name</label>
                                                                                    <input type="text" class="form-control" name="name" value="<?php echo htmlspecialchars($name) ?>" required>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="col-lg-6 col-12">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Amount (₦)</label>
                                                                                    <input type="number" class="form-control" name="amount" value="<?php echo $amount ?>" min="1" step="0.01" required>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="col-lg-6 col-12">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Daily Income (₦)</label>
                                                                                    <input type="number" class="form-control" name="daily_income" value="<?php echo $daily_income ?>" min="0.01" step="0.01" required>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="col-lg-6 col-12">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Duration (days)</label>
                                                                                    <input type="number" class="form-control" name="duration" value="<?php echo $duration ?>" min="1" required>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="col-lg-6 col-12">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Minimum Withdrawal (₦)</label>
                                                                                    <input type="number" class="form-control" name="min_withdrawal" value="<?php echo $min_withdrawal ?>" min="0" step="0.01" required>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="col-lg-6 col-12">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Referral Bonus (₦)</label>
                                                                                    <input type="number" class="form-control" name="referral_bonus" value="<?php echo $referral_bonus ?>" min="0" step="0.01" required>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        
                                                                        <div class="modal-footer">
                                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                                            <button type="submit" name="editPackage" class="btn btn-primary">Save Changes</button>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                    <?php
                                        }
                                    } else {
                                        echo '<tr><td colspan="10" class="text-center">No packages found</td></tr>';
                                    }
                                } catch (Exception $e) {
                                    echo '<tr><td colspan="10" class="text-center text-danger">Error loading packages: ' . $e->getMessage() . '</td></tr>';
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include "inc/footer.php"; ?>