<?php 
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/user/admin/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/user/admin/actions/payouts.php";


function getPackage($username){
    global $link;
    $sql=$link->prepare("SELECT * FROM users WHERE username=?");
    $sql->bind_param("s", $username);
    $sql->execute();
    $result=$sql->get_result();
    $numrow=$result->num_rows;
    $row=$result->fetch_assoc();
    $package=$row['plantype'];
    
    if($package =="plan_a"){
        return "Lite Package";
    } 
    else if($package =="plan_b"){
        return "Smart Package";
    }
    
}


include"inc/header.php" ;

?>


                <div class="container-fluid">

                    <div class="layout-specing">

                        <div class="d-md-flex justify-content-between align-items-center">

                            <h5 class="mb-0">Withdrawal</h5>



                            <nav aria-label="breadcrumb" class="d-inline-block mt-2 mt-sm-0">
                                <ul class="breadcrumb bg-transparent rounded mb-0 p-0">

                                    <li class="breadcrumb-item text-capitalize"><a href="dashboard.php"><?php echo $sitename?></a></li>

                                   

                                    <li class="breadcrumb-item text-capitalize active" aria-current="page">Ref Payouts Request </li>

                                </ul>

                            </nav>

                        </div>

                    





                                                    <div class="col-xl-8 mt-4">


                                <?php 
                                if(isset($_GET['s']) && !empty($_GET['s'])){
                                    $search=$_GET['s'];
                                    $text="Payout request for  <strong>$search</strong>";
                                }
                                else{
                                    $text="Payout Requests";
                                }

                                echo $payoutMsg
                                
                                ?>

                                <div class="d-flex justify-content-between p-4 bg-white shadow rounded-top">


                                    <h6 class="fw-bold mb-0"><?php echo $text?></h6>







                                    <ul class="list-unstyled mb-0">



                                        <li class="dropdown dropdown-primary list-inline-item">



                                            <button type="button" class="btn btn-icon btn-pills btn-soft-primary dropdown-toggle p-0" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="ti ti-dots-vertical"></i></button>



                                            <div class="dropdown-menu dd-menu dropdown-menu-end bg-white shadow border-0 mt-3 py-3">



                                                <a class="dropdown-item text-dark" href="#"> Used</a>



                                                <a class="dropdown-item text-dark" href="#"> Unused</a>



                                            </div>



                                        </li>



                                    </ul>



                                </div>



                                <div class="table-responsive shadow rounded-bottom" data-simplebar>



                                    <table class="table table-center bg-white mb-0" id="myTable">



                                        <thead>

                                        

                                            <tr>



                                                <th class="border-bottom p-3">No.</th>



                                                <th class="border-bottom p-3" style="min-width: 220px;">Username</th>



                                                <th class="border-bottom p-3" style="min-width: 220px;">Bank Details</th>



                                                <th class="text-center border-bottom p-3">Amount</th>
                                                <th class="text-center border-bottom p-3">Package</th>



                                                <th class="text-center border-bottom p-3" style="min-width: 150px;">Submitted Date</th>



                                                <th class="text-center border-bottom p-3">Status</th>



                                                <th class="text-end border-bottom p-3" style="min-width: 100px;">Approve</th>



                                                <th class="text-end border-bottom p-3" style="min-width: 100px;">Decline</th>

<th class="text-end border-bottom p-3" style="min-width: 100px;">View User</th>



                                            </tr>


                                        </thead>



                                        <tbody>



                                            <!-- Start -->

                                            <?php 
                                                if(isset($_GET['s']) && !empty($_GET['s'])){
                                                    $search=filter_string($_GET['s']);
                                                    $sql=$link->prepare("SELECT * FROM withdrawals WHERE type='referral' AND username=? ORDER BY id ASC");
                                                    $sql->bind_param("s", $search);
                                                }
                                                else{
                                                    $sql=$link->prepare("SELECT * FROM withdrawals WHERE type='referral' AND status='pending' ORDER BY id ASC");
                                                }
                                                $sql->execute();
                                                $result=$sql->get_result();
                                                
                                                $numrow=$result->num_rows;
                                                if($numrow > 0){
                                                    $idCount=0;
                                                    while($row=$result->fetch_assoc()){
                                                        $idCount++;
                                                        $username=$row['username'];
                                                        $date=$row['date'];
                                                        $amount=$row['amount'];
                                                        //$package=$row['package'];
                                                        $status=$row['status'];
                                                        $id=$row['id'];


                                                        $sql_acct=$link->prepare("SELECT * FROM bankaccounts WHERE username=?");
                                                        $sql_acct->bind_param("s", $username);
                                                        $sql_acct->execute();
                                                        $result_act=$sql_acct->get_result();
                                                        $row_acct=$result_act->fetch_assoc();
                                                        $bankName=$row_acct['bankname'];
                                                        $acctNum=$row_acct['acctnum'];
                                                        $acctName=$row_acct['acctname'];

                                                        $bankDetails="$bankName $acctNum $acctName";

                                                        if($status == "pending"){
                                                            $statusColor="warning";
                                                        }
                                                        else if($status == "rejected"){
                                                            $statusColor="danger";
                                                        }
                                                        else{
                                                            $statusColor="success";

                                                        }

                                                ?>

                                            <tr>
                                                <th class="p-3"><?php echo $idCount?></th>
                                                <td class="p-3">
                                                        <div class="d-flex align-items-center">
                                                            <span class="ms-2"><?php echo $username?></span>
                                                        </div>
                                                </td>
                                                <td class="p-3">
                                                        <div class="d-flex align-items-center">
                                                            <span class="ms-2"><?php echo $bankDetails?></span>
                                                        </div>
                                                </td>
                                                <td class="text-center p-3">₦<?php echo number_format($amount, 2)?></td>
                                                <td class="text-center p-3"><?php echo getPackage($username) ?></td>
                                                <td class="text-center p-3"><?php echo $date?></td>
                                                <td class="text-center p-3">
                                                    <div class="badge bg-soft-<?php echo $statusColor?> rounded px-3 py-1">
                                                    <?php echo $status?>
                                                    </div>
                                                </td>
                                                <td class="text-end p-3">
                                                    <button class="btn btn-sm btn-primary approve">Approve</button>
                                                </td>
                                                       <td class="text-end p-3">
                                                    <button class="btn btn-sm btn-danger decline">Decline</button> </td>
                                                    <td class="text-end p-3">
                                                    <a href="edit-user.php?username=<?php echo $username?>" class="btn btn-sm btn-primary">View User </a>
                                                </td>          
                                                <input type="hidden" class="id" value="<?php echo $id?>">
                                            </tr>
                                        <?php }} ?>
                                            <!-- End -->
                                        </tbody>



                                    </table>



                                </div>



                            </div><!--end col-->

                    </div>

                </div><!--end container-->

                <script>
                    $(".approve").on("click", function(){
                        let id= $(this).closest("tr").find(".id").val();
                        let actionType="approve";
                        action(id, actionType);
                        
                    })
                    $(".decline").on("click", function(){
                        let id= $(this).closest("tr").find(".id").val();
                        let actionType="decline";
                        action(id, actionType);
                        
                    })
                    function action(id, action){
                        let form=document.createElement('form');
                        let inputID=document.createElement('input');
                        let inputAction=document.createElement('input');
                        let body=document.querySelector('body');
                        form.method="POST";

                        inputID.type="hidden";
                        inputID.value=id;
                        inputID.name="id";

                        inputAction.type="hidden";
                        inputAction.value=action;
                        inputAction.name=action;

                        form.appendChild(inputAction);
                        form.appendChild(inputID);
                        body.appendChild(form);
                        form.submit();
                    }


                </script>

<?php include"inc/footer.php" ?>

                