<?php 
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/user/admin/includes/generalinclude.php";

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Set the timezone explicitly to avoid any date/time issues
date_default_timezone_set('UTC');

// Debug database connection
if (!$link) {
    die("Database connection failed: " . mysqli_connect_error());
}

// Check if tasks table exists, create if not
$tableCheck = $link->query("SHOW TABLES LIKE 'tasks'");
if ($tableCheck->num_rows == 0) {
    $createTable = "CREATE TABLE `tasks` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `title` varchar(255) NOT NULL,
        `description` text NOT NULL,
        `image` varchar(255) DEFAULT NULL,
        `link` text NOT NULL,
        `amount` decimal(10,2) NOT NULL,
        `social_platform` varchar(50) NOT NULL,
        `duration_type` varchar(20) DEFAULT NULL,
        `duration_value` int(11) DEFAULT NULL,
        `expiration_date` datetime DEFAULT NULL,
        `status` tinyint(1) NOT NULL DEFAULT '1',
        `date_created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    if ($link->query($createTable)) {
        $taskMsg = '<div class="alert alert-info">Tasks table created successfully!</div>';
    } else {
        die("Error creating tasks table: " . $link->error);
    }
} else {
    // Check if duration_type column exists, add if not
    $columnCheck = $link->query("SHOW COLUMNS FROM `tasks` LIKE 'duration_type'");
    if ($columnCheck->num_rows == 0) {
        $link->query("ALTER TABLE `tasks` ADD COLUMN `duration_type` VARCHAR(20) DEFAULT NULL AFTER `social_platform`");
    }
    
    // Check if duration_value column exists, add if not
    $columnCheck = $link->query("SHOW COLUMNS FROM `tasks` LIKE 'duration_value'");
    if ($columnCheck->num_rows == 0) {
        $link->query("ALTER TABLE `tasks` ADD COLUMN `duration_value` INT(11) DEFAULT NULL AFTER `duration_type`");
    }
    
    // Remove old duration columns if they exist
    $columnCheck = $link->query("SHOW COLUMNS FROM `tasks` LIKE 'duration_hours'");
    if ($columnCheck->num_rows > 0) {
        $link->query("ALTER TABLE `tasks` DROP COLUMN `duration_hours`");
    }
    
    $columnCheck = $link->query("SHOW COLUMNS FROM `tasks` LIKE 'duration_days'");
    if ($columnCheck->num_rows > 0) {
        $link->query("ALTER TABLE `tasks` DROP COLUMN `duration_days`");
    }
}

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Add new task
    if (isset($_POST['addTask'])) {
        try {
            $title = $_POST['title'];
            $description = $_POST['description'];
            $amount = $_POST['amount'];
            $link_url = $_POST['link']; // Renamed to avoid conflict with $link variable
            $socialPlatform = $_POST['socialPlatform'];
            $durationType = $_POST['durationType'];
            $durationValue = $_POST['durationValue'] ?? null;
            
            // Handle image upload (optional)
            $image = '';
            if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
                $targetDir = $_SERVER['DOCUMENT_ROOT'] . "/$stream/assets/images/tasks/";
                if (!file_exists($targetDir)) {
                    mkdir($targetDir, 0777, true);
                }
                
                $fileName = time() . '_' . basename($_FILES["image"]["name"]);
                $targetFilePath = $targetDir . $fileName;
                
                if (move_uploaded_file($_FILES["image"]["tmp_name"], $targetFilePath)) {
                    $image = "assets/images/tasks/" . $fileName;
                } else {
                    throw new Exception("Failed to upload image. Error: " . $_FILES["image"]["error"]);
                }
            }
            
            // Calculate expiration date
            $expirationDate = null;
            if ($durationType && $durationValue) {
                if ($durationType == 'hours') {
                    $expirationDate = date('Y-m-d H:i:s', strtotime("+$durationValue hours"));
                } elseif ($durationType == 'days') {
                    $expirationDate = date('Y-m-d H:i:s', strtotime("+$durationValue days"));
                }
            }
            
            // Modified to explicitly set status:
            $stmt = $link->prepare("INSERT INTO tasks (title, description, image, link, amount, social_platform, duration_type, duration_value, expiration_date, status, date_created) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, 1, NOW())");
            $stmt->bind_param("ssssdsiis", $title, $description, $image, $link_url, $amount, $socialPlatform, $durationType, $durationValue, $expirationDate);
            
            if ($stmt->execute()) {
                // Get the inserted task ID for debugging
                $insertedId = $stmt->insert_id;
                
                // Fetch the inserted task for verification
                $fetchTask = $link->prepare("SELECT * FROM tasks WHERE id = ?");
                $fetchTask->bind_param("i", $insertedId);
                $fetchTask->execute();
                $taskResult = $fetchTask->get_result();
                $taskData = $taskResult->fetch_assoc();
                
                $taskMsg = '<div class="alert alert-success">Task added successfully! 
                    <br>Debug Info: 
                    ID: ' . $insertedId . 
                    ', Status: ' . $taskData['status'] . 
                    ', Expiration: ' . ($taskData['expiration_date'] ?: 'NULL') . 
                    ', Current Time: ' . date('Y-m-d H:i:s') .
                    '</div>';
            } else {
                throw new Exception("Database error: " . $stmt->error);
            }
        } catch (Exception $e) {
            $taskMsg = '<div class="alert alert-danger">Error adding task: ' . $e->getMessage() . '</div>';
        }
    }
    
    // Delete task
    if (isset($_POST['deleteTask'])) {
        try {
            $taskId = $_POST['taskId'];
            $imagePath = $_POST['imagePath'];
            
            // Delete image file if exists
            if (!empty($imagePath)) {
                $fullPath = $_SERVER['DOCUMENT_ROOT'] . "/$stream/" . $imagePath;
                if (file_exists($fullPath)) {
                    unlink($fullPath);
                }
            }
            
            // Delete from database
            $stmt = $link->prepare("DELETE FROM tasks WHERE id = ?");
            $stmt->bind_param("i", $taskId);
            
            if ($stmt->execute()) {
                $taskMsg = '<div class="alert alert-success">Task deleted successfully!</div>';
            } else {
                throw new Exception("Database error: " . $stmt->error);
            }
        } catch (Exception $e) {
            $taskMsg = '<div class="alert alert-danger">Error deleting task: ' . $e->getMessage() . '</div>';
        }
    }
    
    // Update task status
    if (isset($_POST['updateStatus'])) {
        try {
            $taskId = $_POST['taskId'];
            $status = $_POST['status'];
            
            $stmt = $link->prepare("UPDATE tasks SET status = ? WHERE id = ?");
            $stmt->bind_param("ii", $status, $taskId);
            
            if ($stmt->execute()) {
                $taskMsg = '<div class="alert alert-success">Task status updated!</div>';
            } else {
                throw new Exception("Database error: " . $stmt->error);
            }
        } catch (Exception $e) {
            $taskMsg = '<div class="alert alert-danger">Error updating task status: ' . $e->getMessage() . '</div>';
        }
    }
    
    // Edit task
    if (isset($_POST['editTask'])) {
        try {
            $taskId = $_POST['taskId'];
            $title = $_POST['title'];
            $description = $_POST['description'];
            $amount = $_POST['amount'];
            $link_url = $_POST['link'];
            $socialPlatform = $_POST['socialPlatform'];
            $durationType = $_POST['durationType'];
            $durationValue = $_POST['durationValue'] ?? null;
            
            // Get current image path
            $getImage = $link->prepare("SELECT image FROM tasks WHERE id = ?");
            $getImage->bind_param("i", $taskId);
            $getImage->execute();
            $imageResult = $getImage->get_result();
            $imageRow = $imageResult->fetch_assoc();
            $currentImage = $imageRow['image'];
            
            // Handle image upload if a new one is provided
            $image = $currentImage;
            if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
                $targetDir = $_SERVER['DOCUMENT_ROOT'] . "/$stream/assets/images/tasks/";
                if (!file_exists($targetDir)) {
                    mkdir($targetDir, 0777, true);
                }
                
                $fileName = time() . '_' . basename($_FILES["image"]["name"]);
                $targetFilePath = $targetDir . $fileName;
                
                if (move_uploaded_file($_FILES["image"]["tmp_name"], $targetFilePath)) {
                    // Delete old image if exists
                    if (!empty($currentImage)) {
                        $oldImagePath = $_SERVER['DOCUMENT_ROOT'] . "/$stream/" . $currentImage;
                        if (file_exists($oldImagePath)) {
                            unlink($oldImagePath);
                        }
                    }
                    
                    $image = "assets/images/tasks/" . $fileName;
                } else {
                    throw new Exception("Failed to upload image. Error: " . $_FILES["image"]["error"]);
                }
            }
            
            // Calculate expiration date
            $expirationDate = null;
            if ($durationType && $durationValue) {
                if ($durationType == 'hours') {
                    $expirationDate = date('Y-m-d H:i:s', strtotime("+$durationValue hours"));
                } elseif ($durationType == 'days') {
                    $expirationDate = date('Y-m-d H:i:s', strtotime("+$durationValue days"));
                }
            }
            
            // Update task details without changing status
            $stmt = $link->prepare("UPDATE tasks SET title = ?, description = ?, image = ?, link = ?, amount = ?, social_platform = ?, duration_type = ?, duration_value = ?, expiration_date = ? WHERE id = ?");
            $stmt->bind_param("ssssdsiisi", $title, $description, $image, $link_url, $amount, $socialPlatform, $durationType, $durationValue, $expirationDate, $taskId);
            
            if ($stmt->execute()) {
                $taskMsg = '<div class="alert alert-success">Task updated successfully!</div>';
            } else {
                throw new Exception("Database error: " . $stmt->error);
            }
        } catch (Exception $e) {
            $taskMsg = '<div class="alert alert-danger">Error updating task: ' . $e->getMessage() . '</div>';
        }
    }
}

include "inc/header.php";
?>

<div class="container-fluid">
    <div class="layout-specing">
        <div class="d-md-flex justify-content-between align-items-center">
            <h5 class="mb-0">Task Management</h5>
            <nav aria-label="breadcrumb" class="d-inline-block mt-2 mt-sm-0">
                <ul class="breadcrumb bg-transparent rounded mb-0 p-0">
                    <li class="breadcrumb-item text-capitalize"><a href="dashboard">Dashboard</a></li>
                    <li class="breadcrumb-item text-capitalize active" aria-current="page">Tasks</li>
                </ul>
            </nav>
        </div>
        
        <?php if (isset($taskMsg)) echo $taskMsg; ?>
        
        <!-- Add Task Form -->
        <div class="card border-0 rounded shadow mt-4">
            <div class="card-body">
                <h5 class="text-md-start text-center mb-0">Add New Task</h5>
                
                <form method="POST" enctype="multipart/form-data">
                    <div class="row mt-4">
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Task Title</label>
                                <div class="form-icon position-relative">
                                    <i data-feather="type" class="fea icon-sm icons"></i>
                                    <input type="text" class="form-control ps-5" placeholder="Task Title" name="title" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Reward Amount (₦)</label>
                                <div class="form-icon position-relative">
                                    <i data-feather="dollar-sign" class="fea icon-sm icons"></i>
                                    <input type="number" class="form-control ps-5" placeholder="Amount" name="amount" min="1" step="0.01" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Social Platform</label>
                                <div class="form-icon position-relative">
                                    <i data-feather="share-2" class="fea icon-sm icons"></i>
                                    <select class="form-control ps-5" name="socialPlatform" required>
                                        <option value="" selected disabled>Select Platform</option>
                                        <option value="facebook">Facebook</option>
                                        <option value="whatsapp">WhatsApp</option>
                                        <option value="instagram">Instagram</option>
                                        <option value="tiktok">TikTok</option>
                                        <option value="snapchat">Snapchat</option>
                                        <option value="youtube">YouTube</option>
                                        <option value="twitter">Twitter</option>
                                        <option value="linkedin">LinkedIn</option>
                                        <option value="telegram">Telegram</option>
                                        <option value="pinterest">Pinterest</option>
                                        <option value="reddit">Reddit</option>
                                        <option value="discord">Discord</option>
                                        <option value="other">Other</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Task Link</label>
                                <div class="form-icon position-relative">
                                    <i data-feather="link" class="fea icon-sm icons"></i>
                                    <input type="text" class="form-control ps-5" placeholder="Paste any link here" name="link" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Duration Type</label>
                                <div class="form-icon position-relative">
                                    <i data-feather="clock" class="fea icon-sm icons"></i>
                                    <select class="form-control ps-5" name="durationType" id="durationType">
                                        <option value="">No Limit</option>
                                        <option value="hours">Hours</option>
                                        <option value="days">Days</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Duration Value</label>
                                <div class="form-icon position-relative">
                                    <i data-feather="hash" class="fea icon-sm icons"></i>
                                    <select class="form-control ps-5" name="durationValue" id="durationValue" disabled>
                                        <option value="">Select duration type first</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-12">
                            <div class="mb-3">
                                <label class="form-label">Task Description</label>
                                <div class="form-icon position-relative">
                                    <i data-feather="file-text" class="fea icon-sm icons"></i>
                                    <textarea class="form-control ps-5" placeholder="Describe the task..." name="description" rows="3" required></textarea>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-6 col-12">
                            <div class="mb-3">
                                <label class="form-label">Task Image (Optional)</label>
                                <div class="form-icon position-relative">
                                    <i data-feather="image" class="fea icon-sm icons"></i>
                                    <input type="file" class="form-control ps-5" name="image" accept="image/*">
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-sm-12">
                            <input type="submit" name="addTask" class="btn btn-primary" value="Add Task">
                        </div>
                    </div>
                </form>
            </div>
        </div>
        
        <!-- Tasks Table -->
        <div class="col mt-4 pt-2">
            <div class="component-wrapper rounded shadow">
                <div class="p-4 border-bottom">
                    <h4 class="title mb-0">Existing Tasks</h4>
                </div>
                
                <div class="p-4">
                    <div class="table-responsive bg-white shadow rounded">
                        <table class="table mb-0 table-center">
                            <thead>
                                <tr>
                                    <th scope="col" class="border-bottom">#</th>
                                    <th scope="col" class="border-bottom">Title</th>
                                    <th scope="col" class="border-bottom">Platform</th>
                                    <th scope="col" class="border-bottom">Amount</th>
                                    <th scope="col" class="border-bottom">Duration</th>
                                    <th scope="col" class="border-bottom">Expiration</th>
                                    <th scope="col" class="border-bottom">Status</th>
                                    <th scope="col" class="border-bottom">Date</th>
                                    <th scope="col" class="border-bottom">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                try {
                                    $sql = $link->prepare("SELECT * FROM tasks ORDER BY id DESC");
                                    $sql->execute();
                                    $result = $sql->get_result();
                                    
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $id = $row['id'];
                                            $title = $row['title'];
                                            $platform = $row['social_platform'];
                                            $amount = $row['amount'];
                                            $status = $row['status'];
                                            $date = date('M j, Y', strtotime($row['date_created']));
                                            $image = $row['image'];
                                            $description = $row['description'];
                                            $link_url = $row['link'];
                                            $durationType = $row['duration_type'];
                                            $durationValue = $row['duration_value'];
                                            $expirationDate = $row['expiration_date'];
                                            
                                            // Format duration
                                            $durationText = 'No limit';
                                            if ($durationType && $durationValue) {
                                                $durationText = $durationValue . ' ' . $durationType;
                                                if ($durationValue > 1) {
                                                    $durationText .= 's';
                                                }
                                            }
                                            
                                            // Format expiration date
                                            $expirationText = $expirationDate ? date('M j, Y H:i', strtotime($expirationDate)) : 'No expiration';
                                            
                                            $statusBadge = $status ? 
                                                '<span class="badge bg-success">Active</span>' : 
                                                '<span class="badge bg-danger">Inactive</span>';
                                    ?>
                                            <tr>
                                                <th scope="row"><?php echo $id ?></th>
                                                <td><?php echo $title ?></td>
                                                <td><?php echo ucfirst($platform) ?></td>
                                                <td>₦<?php echo number_format($amount, 2) ?></td>
                                                <td><?php echo $durationText ?></td>
                                                <td><?php echo $expirationText ?></td>
                                                <td><?php echo $statusBadge ?></td>
                                                <td><?php echo $date ?></td>
                                                <td>
                                                    <div class="d-flex gap-2 flex-wrap">
                                                        <!-- Edit Task Button -->
                                                        <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editTaskModal<?php echo $id ?>">
                                                            <i class="fas fa-edit"></i> Edit
                                                        </button>
                                                        
                                                        <!-- Status Toggle Button -->
                                                        <form method="post" class="d-inline">
                                                            <input type="hidden" name="taskId" value="<?php echo $id ?>">
                                                            <input type="hidden" name="status" value="<?php echo $status ? 0 : 1 ?>">
                                                            <button type="submit" name="updateStatus" class="btn btn-sm btn-<?php echo $status ? 'warning' : 'success' ?>">
                                                                <?php echo $status ? 'Deactivate' : 'Activate' ?>
                                                            </button>
                                                        </form>
                                                        
                                                        <!-- Delete Button -->
                                                        <form method="post" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this task?')">
                                                            <input type="hidden" name="taskId" value="<?php echo $id ?>">
                                                            <input type="hidden" name="imagePath" value="<?php echo $image ?>">
                                                            <button type="submit" name="deleteTask" class="btn btn-sm btn-danger">
                                                                <i class="fas fa-trash"></i> Delete
                                                            </button>
                                                        </form>
                                                    </div>
                                                    
                                                    <!-- Edit Task Modal -->
                                                    <div class="modal fade" id="editTaskModal<?php echo $id ?>" tabindex="-1" aria-labelledby="editTaskModalLabel<?php echo $id ?>" aria-hidden="true">
                                                        <div class="modal-dialog modal-lg">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title" id="editTaskModalLabel<?php echo $id ?>">Edit Task</h5>
                                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <form method="POST" enctype="multipart/form-data">
                                                                        <input type="hidden" name="taskId" value="<?php echo $id ?>">
                                                                        
                                                                        <div class="row">
                                                                            <div class="col-lg-6 col-12">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Task Title</label>
                                                                                    <input type="text" class="form-control" name="title" value="<?php echo htmlspecialchars($title) ?>" required>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="col-lg-6 col-12">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Reward Amount (₦)</label>
                                                                                    <input type="number" class="form-control" name="amount" value="<?php echo $amount ?>" min="1" step="0.01" required>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="col-lg-6 col-12">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Social Platform</label>
                                                                                    <select class="form-control" name="socialPlatform" required>
                                                                                        <option value="facebook" <?php echo $platform == 'facebook' ? 'selected' : '' ?>>Facebook</option>
                                                                                        <option value="whatsapp" <?php echo $platform == 'whatsapp' ? 'selected' : '' ?>>WhatsApp</option>
                                                                                        <option value="instagram" <?php echo $platform == 'instagram' ? 'selected' : '' ?>>Instagram</option>
                                                                                        <option value="tiktok" <?php echo $platform == 'tiktok' ? 'selected' : '' ?>>TikTok</option>
                                                                                        <option value="snapchat" <?php echo $platform == 'snapchat' ? 'selected' : '' ?>>Snapchat</option>
                                                                                        <option value="youtube" <?php echo $platform == 'youtube' ? 'selected' : '' ?>>YouTube</option>
                                                                                        <option value="twitter" <?php echo $platform == 'twitter' ? 'selected' : '' ?>>Twitter</option>
                                                                                        <option value="linkedin" <?php echo $platform == 'linkedin' ? 'selected' : '' ?>>LinkedIn</option>
                                                                                        <option value="telegram" <?php echo $platform == 'telegram' ? 'selected' : '' ?>>Telegram</option>
                                                                                        <option value="pinterest" <?php echo $platform == 'pinterest' ? 'selected' : '' ?>>Pinterest</option>
                                                                                        <option value="reddit" <?php echo $platform == 'reddit' ? 'selected' : '' ?>>Reddit</option>
                                                                                        <option value="discord" <?php echo $platform == 'discord' ? 'selected' : '' ?>>Discord</option>
                                                                                        <option value="other" <?php echo $platform == 'other' ? 'selected' : '' ?>>Other</option>
                                                                                    </select>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="col-lg-6 col-12">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Task Link</label>
                                                                                    <input type="text" class="form-control" name="link" value="<?php echo htmlspecialchars($link_url) ?>" required>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="col-lg-6 col-12">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Duration Type</label>
                                                                                    <select class="form-control" name="durationType">
                                                                                        <option value="" <?php echo empty($durationType) ? 'selected' : '' ?>>No Limit</option>
                                                                                        <option value="hours" <?php echo $durationType == 'hours' ? 'selected' : '' ?>>Hours</option>
                                                                                        <option value="days" <?php echo $durationType == 'days' ? 'selected' : '' ?>>Days</option>
                                                                                    </select>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="col-lg-6 col-12">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Duration Value</label>
                                                                                    <input type="number" class="form-control" name="durationValue" value="<?php echo $durationValue ?>" min="1">
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="col-12">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Task Description</label>
                                                                                    <textarea class="form-control" name="description" rows="3" required><?php echo htmlspecialchars($description) ?></textarea>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="col-lg-6 col-12">
                                                                                <div class="mb-3">
                                                                                    <label class="form-label">Task Image (Optional)</label>
                                                                                    <input type="file" class="form-control" name="image" accept="image/*">
                                                                                    <?php if (!empty($image)): ?>
                                                                                    <div class="mt-2">
                                                                                        <img src="<?php echo $stream . '/' . $image ?>" alt="Current image" style="max-height: 100px;">
                                                                                    </div>
                                                                                    <?php endif; ?>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        
                                                                        <div class="modal-footer">
                                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                                            <button type="submit" name="editTask" class="btn btn-primary">Save Changes</button>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                    <?php
                                        }
                                    } else {
                                        echo '<tr><td colspan="9" class="text-center">No tasks found</td></tr>';
                                    }
                                } catch (Exception $e) {
                                    echo '<tr><td colspan="9" class="text-center text-danger">Error loading tasks: ' . $e->getMessage() . '</td></tr>';
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const durationType = document.getElementById('durationType');
    const durationValue = document.getElementById('durationValue');
    
    if (durationType && durationValue) {
        durationType.addEventListener('change', function() {
            // Clear existing options
            durationValue.innerHTML = '';
            
            if (this.value === '') {
                durationValue.disabled = true;
                durationValue.innerHTML = '<option value="">No duration selected</option>';
                return;
            }
            
            durationValue.disabled = false;
            
            // Add options based on duration type
            if (this.value === 'hours') {
                for (let i = 1; i <= 24; i++) {
                    const option = document.createElement('option');
                    option.value = i;
                    option.textContent = i + ' hour' + (i > 1 ? 's' : '');
                    durationValue.appendChild(option);
                }
            } else if (this.value === 'days') {
                for (let i = 1; i <= 30; i++) {
                    const option = document.createElement('option');
                    option.value = i;
                    option.textContent = i + ' day' + (i > 1 ? 's' : '');
                    durationValue.appendChild(option);
                }
            }
        });
    }
});
</script>

<?php include "inc/footer.php"; ?>