//all input fields buying validation/popup

$(document).ready(function () {
  // listen for changes to the form fields
  $("form input").on("change", function () {
    // check if all form fields are filled
    var allFieldsFilled = true;
    $("form input").each(function () {
      if ($(this).val() === "") {
        allFieldsFilled = false;
        return false; // break out of the loop early
      }
    });

    // update the submit button attributes
    var submitButton = $('form button[type="submit"]');
    if (allFieldsFilled) {
      submitButton.removeAttr("submit");
      submitButton.attr("data-bs-toggle", "offcanvas");
      submitButton.attr("data-bs-target", "#trxConfirm");
    } else {
      submitButton.attr("submit", ""); // add the submit attribute back
      submitButton.removeAttr("data-bs-toggle");
      submitButton.removeAttr("data-bs-target");
    }
  });
});

$(document).ready(function () {
  $(".js-select.biller").on("change", function () {
    var selectedOption = $(this).find(":selected");
    var selectedBiller = selectedOption.text();
    var imgSrc = selectedOption.data("img");
    var img = new Image();
    img.src = imgSrc;
    $("#biller").empty().append(selectedBiller);
  });

  $(".amt").on("input", function () {
    $("#amt").text("NGN " + $(this).val());
  });

  $(".phone").on("input", function () {
    $("#phone").text($(this).val());
  } );
    
    $(".name").on("input", function () {
      $("#name").text($(this).val());
    });

  $(".quantity").on("change", function () {
    $("#quantity").text($(this).val());
  });

  $(".plan").on("change", function () {
    $("#planType").text($(this).find("option:selected").text());
  });

  $(".amt").on("input", function () {
    let inputVal = $(this).val();
    let percentage = (inputVal * 2) / 100;
    $("#commission").text("NGN " + percentage);
  });
});

