<?php
require $_SERVER['DOCUMENT_ROOT']."/stream.php";
require $_SERVER['DOCUMENT_ROOT']."$stream/includes/generalinclude.php";

// Check if tasks table exists
$tableExists = false;
$result = $link->query("SHOW TABLES LIKE 'tasks'");
if ($result->num_rows > 0) {
    $tableExists = true;
}

if (!$tableExists) {
    // Create the tasks table
    $createTableSQL = "CREATE TABLE `tasks` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `title` varchar(255) NOT NULL,
        `description` text NOT NULL,
        `image` varchar(255) NOT NULL,
        `link` varchar(255) NOT NULL,
        `amount` decimal(10,2) NOT NULL,
        `social_platform` varchar(50) NOT NULL,
        `duration_hours` int(11) NOT NULL DEFAULT '0',
        `duration_days` int(11) NOT NULL DEFAULT '0',
        `expiration_date` datetime NULL DEFAULT NULL,
        `status` tinyint(1) NOT NULL DEFAULT '1',
        `date_created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    if ($link->query($createTableSQL)) {
        echo "Tasks table created successfully!";
    } else {
        echo "Error creating tasks table: " . $link->error;
    }
} else {
    // Check if the table has the required columns
    $requiredColumns = [
        'id', 'title', 'description', 'image', 'link', 'amount', 
        'social_platform', 'duration_hours', 'duration_days', 
        'expiration_date', 'status', 'date_created'
    ];
    
    $columnsResult = $link->query("SHOW COLUMNS FROM tasks");
    $existingColumns = [];
    
    while ($row = $columnsResult->fetch_assoc()) {
        $existingColumns[] = $row['Field'];
    }
    
    $missingColumns = array_diff($requiredColumns, $existingColumns);
    
    if (!empty($missingColumns)) {
        echo "Missing columns: " . implode(', ', $missingColumns) . "<br>";
        
        // Add missing columns
        foreach ($missingColumns as $column) {
            $alterSQL = "";
            switch ($column) {
                case 'duration_hours':
                    $alterSQL = "ALTER TABLE `tasks` ADD COLUMN `duration_hours` INT(11) NOT NULL DEFAULT '0' AFTER `social_platform`";
                    break;
                case 'duration_days':
                    $alterSQL = "ALTER TABLE `tasks` ADD COLUMN `duration_days` INT(11) NOT NULL DEFAULT '0' AFTER `duration_hours`";
                    break;
                case 'expiration_date':
                    $alterSQL = "ALTER TABLE `tasks` ADD COLUMN `expiration_date` DATETIME NULL DEFAULT NULL AFTER `duration_days`";
                    break;
            }
            
            if (!empty($alterSQL)) {
                if ($link->query($alterSQL)) {
                    echo "Added column: $column<br>";
                } else {
                    echo "Error adding column $column: " . $link->error . "<br>";
                }
            }
        }
    } else {
        echo "Tasks table exists with all required columns.";
    }
}

// Check if user_tasks table exists
$tableExists = false;
$result = $link->query("SHOW TABLES LIKE 'user_tasks'");
if ($result->num_rows > 0) {
    $tableExists = true;
}

if (!$tableExists) {
    // Create the user_tasks table
    $createTableSQL = "CREATE TABLE `user_tasks` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `task_id` int(11) NOT NULL,
        `username` varchar(100) NOT NULL,
        `completion_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        UNIQUE KEY `user_task_unique` (`task_id`,`username`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    if ($link->query($createTableSQL)) {
        echo "<br>User tasks table created successfully!";
    } else {
        echo "<br>Error creating user tasks table: " . $link->error;
    }
} else {
    echo "<br>User tasks table exists.";
}
?>