<!DOCTYPE html>
<html lang="en">
<head>
    <base href="/user/">
    <meta charset="utf-8">
    <meta name="author" content="Goextrawave">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="<?php echo $sitedesc ?>">
    <title><?php echo $ptitle ?> - <?php echo $sitename ?></title>
    <link rel="shortcut icon" href="../favicon.png">
    <link rel="preload" as="style" onload="this.rel = 'stylesheet'" href="assets/css/style926d.css?v1.1.1">
    <noscript><link rel="stylesheet" href="assets/css/style926d.css?v1.1.1"></noscript>
    <link rel="stylesheet" href="assets/css/loader.css?v1.1.1">
    <link rel="stylesheet" href="assets/css/toastify.css?v1.1.1">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://kit.fontawesome.com/2cac68a182.js" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="assets/css/libs/editors/quill926d.css?v1.1.1"></link>
    
    <!-- Brixolage Font -->
    <link href="https://fonts.googleapis.com/css2?family=Bebas+Neue&family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #013fa4;
            --primary-hover: #012d79;
            --primary-light: rgba(1, 63, 164, 0.1);
            --primary-dark: #011f4d;
            --brixolage: 'Bebas Neue', cursive;
            --roboto: 'Roboto', sans-serif;
        }
        
        body {
            font-family: var(--roboto);
        }
        
        .nk-sidebar.is-theme-dark {
            background: rgba(1, 63, 164, 0.75) !important;
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border-right: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
        }
        
        .nk-menu-link {
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            padding: 15px 20px !important;
            z-index: 1;
        }
        
        .nk-menu-link:hover {
            background-color: rgba(255, 255, 255, 0.1) !important;
            transform: translateX(5px);
        }
        
        .nk-menu-link:before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s;
        }
        
        .nk-menu-link:hover:before {
            left: 100%;
        }
        
        .nk-menu-icon em {
            color: #ffffff !important;
            transition: transform 0.3s ease;
            font-size: 1.5rem !important;
        }
        
        .nk-menu-link:hover .nk-menu-icon em {
            transform: scale(1.2);
        }
        
        .nk-menu-text {
            color: rgba(255, 255, 255, 0.9) !important;
            font-weight: 500;
            font-size: 1.2rem !important;
            letter-spacing: 0.5px;
            font-family: var(--brixolage);
        }
        
        .nk-menu-item.active .nk-menu-link {
            background-color: rgba(255, 255, 255, 0.15) !important;
            border-left: 3px solid #ffffff;
        }
        
        .btn-primary {
            background-color: var(--primary-color) !important;
            border-color: var(--primary-color) !important;
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            background-color: var(--primary-hover) !important;
            border-color: var(--primary-hover) !important;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        
        .nk-header {
            background: rgba(255, 255, 255, 0.85) !important;
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .logo-svg {
            transition: transform 0.3s ease;
        }
        
        .logo-svg:hover {
            transform: scale(1.05);
        }
        
        .nk-menu-item {
            margin: 8px 0;
            border-radius: 4px;
            overflow: hidden;
        }
        
        .nk-menu-heading {
            margin-top: 20px;
            margin-bottom: 10px;
        }
        
        .nk-menu-heading h6 {
            color: rgba(255, 255, 255, 0.7) !important;
            font-size: 0.9rem !important;
            letter-spacing: 1px;
            font-family: var(--brixolage);
            text-transform: uppercase;
        }
        
        .nk-sidebar-toggle button,
        .nk-compact-toggle button {
            background-color: rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
        }
        
        .nk-sidebar-toggle button:hover,
        .nk-compact-toggle button:hover {
            background-color: rgba(255, 255, 255, 0.2);
            transform: rotate(90deg);
        }
        
        .dropdown-menu {
            background: rgba(255, 255, 255, 0.85) !important;
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            animation: fadeIn 0.3s ease;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .media-group:hover {
            transform: scale(1.02);
            transition: transform 0.3s ease;
        }
        
        .link-list li a {
            transition: all 0.3s ease;
        }
        
        .link-list li a:hover {
            background-color: var(--primary-light);
            padding-left: 15px;
        }
        
        .app-download {
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(5px);
            -webkit-backdrop-filter: blur(5px);
            border-radius: 8px;
            padding: 15px;
            margin-top: 20px;
            text-align: center;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
            z-index: 1;
            position: relative;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .app-download:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
        }
        
        .app-download h4 {
            color: white;
            font-family: var(--brixolage);
            font-size: 1.5rem;
            margin-bottom: 10px;
        }
        
        .app-download p {
            color: rgba(255, 255, 255, 0.8);
            margin-bottom: 15px;
        }
        
        .app-download .btn {
            background-color: white;
            color: var(--primary-color);
            font-weight: bold;
            border: none;
            border-radius: 50px;
            padding: 8px 20px;
            transition: all 0.3s ease;
        }
        
        .app-download .btn:hover {
            transform: scale(1.05);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }
        
        .site-title {
            font-family: var(--brixolage);
            font-size: 2rem;
            color: var(--primary-color);
            letter-spacing: 1px;
        }
        
        .nk-wrap {
            background-color: #f5f7fb;
        }
        
        .nk-body {
            background-color: #f5f7fb;
        }
    </style>
    
    <script>
        $(window).on('load', function() {
            $('#notifyModal').modal('show');
        });
    </script>
</head>
<body class="nk-body" data-sidebar-collapse="lg" data-navbar-collapse="lg">
    <div class="nk-app-root">
        <div class="nk-wave">
            <div class="nk-sidebar nk-sidebar-fixed is-theme-dark" id="sidebar">
                <div class="nk-sidebar-element nk-sidebar-head">
                    <div class="nk-sidebar-brand">
                        <a href="../user/index" class="logo-link">
                            <div class="logo-wrap">
                                <img class="logo-svg" src="../igr.png" width="200" alt="Goextra Logo">
                            </div>
                        </a>
                        <div class="nk-compact-toggle me-n1">
                            <button class="btn btn-md btn-icon text-light btn-no-hover compact-toggle">
                                <em class="icon off ni ni-chevrons-left"></em><em class="icon on ni ni-chevrons-right"></em>
                            </button>
                        </div>
                        <div class="nk-sidebar-toggle me-n1">
                            <button class="btn btn-md btn-icon text-light btn-no-hover sidebar-toggle">
                                <em class="icon ni ni-arrow-left"></em>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="nk-sidebar-element nk-sidebar-body">
                    <div class="nk-sidebar-content">
                        <div class="nk-sidebar-menu" data-simplebar>
                            <ul class="nk-menu">
                                <li class="nk-menu-item active">
                                    <a href="../user/index.php" class="nk-menu-link">
                                        <span class="nk-menu-icon">
                                            <em class="icon ni ni-grid-fill-c"></em>
                                        </span>
                                        <span class="nk-menu-text">Investment Dashboard</span>
                                    </a>
                                </li>
                                
                                <li class="nk-menu-item">
                                    <a href="../user/user_adverts.php" class="nk-menu-link">
                                        <span class="nk-menu-icon">
                                            <em class="icon ni ni-note-add-fill-c"></em>
                                        </span>
                                        <span class="nk-menu-text">Advert</span>
                                    </a>
                                </li>
                                
                                <li class="nk-menu-item">
                                    <a href="../user/user_withdrawal.php" class="nk-menu-link">
                                        <span class="nk-menu-icon">
                                            <em class="icon ni ni-wallet-fill"></em>
                                        </span>
                                        <span class="nk-menu-text">Cashout</span>
                                    </a>
                                </li>
                                
                               <li class="nk-menu-item">
  <a href="../user/user_packages.php" class="nk-menu-link" aria-label="View Packages">
    <span class="nk-menu-icon" title="View Packages">
      <em class="icon ni ni-briefcase"></em>
    </span>
    <span class="nk-menu-text">View Packages</span>
  </a>
</li>

                                
                                <li class="nk-menu-heading">
                                    <h6 class="overline-title">Account</h6>
                                </li>
                                
                                <li class="nk-menu-item">
                                    <a href="settings" class="nk-menu-link">
                                        <span class="nk-menu-icon">
                                            <em class="icon ni ni-setting-alt-fill"></em>
                                        </span>
                                        <span class="nk-menu-text">Settings</span>
                                    </a>
                                </li>
                                
                                <li class="nk-menu-item">
                                    <a href="logout" class="nk-menu-link">
                                        <span class="nk-menu-icon">
                                            <em class="icon ni ni-signout"></em>
                                        </span>
                                        <span class="nk-menu-text">Logout</span>
                                    </a>
                                </li>
                                
                                <div class="app-download">
                                    <h4>Download Our App</h4>
                                    <p>Get the best experience on mobile</p>
                                    <a href="#" class="btn">
                                        <i class="fas fa-download me-2"></i>Download Now
                                    </a>
                                </div>
                                
                                <div class="mt-5"></div>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="nk-wrap">
                <div class="nk-header nk-header-fixed">
                    <div class="container-fluid">
                        <div class="nk-header-wrap">
                            <div class="nk-header-logo ms-n1">
                                <div class="nk-sidebar-toggle ">
                                    <button class="btn btn-icon btn-sm btn-zoom sidebar-toggle d-sm-none mr-5">
                                        <em class="icon ni ni-menu"></em>
                                    </button>
                                    <button class="btn btn-icon btn-md btn-zoom sidebar-toggle d-none d-sm-inline-flex">
                                        <em class="icon ni ni-menu"></em>
                                    </button>
                                </div>
                                <a href="../user/index.php" class="logo-link">
                                    <div class="logo-wrap">
                                        <img class="logo-svg" src="../igr.png" width="120" alt="Goextra Logo">
                                        
                                    </div>
                                </a>
                            </div>
                            <nav class="nk-header-menu nk-navbar">
                                <ul class="nk-nav">
                                </ul>
                            </nav>
                            <div class="nk-header-tools">
                                <ul class="nk-quick-nav ms-2">
                                    <li class="dropdown">
                                        <a href="profile" data-bs-toggle="dropdown">
                                            <div class="d-sm-none">
                                                <div class="media media-md media-circle">
                                                    <img src="../igr.png" alt="" class="img-thumbnail" />
                                                </div>
                                            </div>
                                            <div class="d-none d-sm-block">
                                                <div class="media media-circle">
                                                    <img src="../igr.png" alt="" class="img-thumbnail" />
                                                </div>
                                            </div>
                                        </a>
                                        <div class="dropdown-menu dropdown-menu-md">
                                            <div class="dropdown-content dropdown-content-x-lg py-3 border-bottom border-light">
                                                <div class="media-group">
                                                    <div class="media media-xl media-middle media-circle">
                                                        <img src="../igr.png" alt="" class="img-thumbnail" />
                                                    </div>
                                                    <div class="media-text">
                                                        <div class="lead-text"><?php echo $fullname ?></div>
                                                        <span class="sub-text"><?php echo $username ?></span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="dropdown-content dropdown-content-x-lg py-3 border-bottom border-light">
                                                <ul class="link-list">
                                                    <li>
                                                        <a href="settings"><em class="icon ni ni-setting-alt-fill"></em>
                                                            <span>Account Settings</span></a>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="dropdown-content dropdown-content-x-lg py-3">
                                                <ul class="link-list">
                                                    <li>
                                                        <a href="logout"><em class="icon ni ni-signout"></em>
                                                            <span>Log Out</span></a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>