<?php 
require $_SERVER['DOCUMENT_ROOT'] . "/stream.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/user/includes/generalinclude.php";
 $ptitle = "Dashboard";
// Removed the line that adds referral funds to total
 $totalFunds = $funds; // Now only shows flow_cash balance

if($planType =="plan_a"){
    $package="Gainmart Starter";
    $packageIcon = "fas fa-rocket"; // Icon for Starter package
    $packageColor = "#75AFEE"; // Gainmart blue color
}
else if($planType =="plan_b"){
    $package="Gainmart Premium";
    $packageIcon = "fas fa-crown"; // Icon for Premium package
    $packageColor = "#75AFEE"; // Gainmart blue color
}
else if($planType =="plan_c"){
    $package="Student Package";
    $packageIcon = "fas fa-graduation-cap"; // Icon for Student package
    $packageColor = "#75AFEE"; // Gainmart blue color
}

// Determine referral badge based on number of referrals
if ($totalReferrals < 1) {
    $referralBadge = "None";
    $badgeColor = "#6c757d"; // Gray
    $nextBadge = "Beginner";
    $progressPercentage = 0;
    $progressMax = 1;
} elseif ($totalReferrals < 10) {
    $referralBadge = "Beginner";
    $badgeColor = "#75AFEE"; // Gainmart blue
    $nextBadge = "Vendor";
    $progressPercentage = ($totalReferrals / 10) * 100;
    $progressMax = 10;
} else {
    $referralBadge = "Vendor";
    $badgeColor = "#75AFEE"; // Gainmart blue
    $nextBadge = "Expert";
    $progressPercentage = min(100, (($totalReferrals - 10) / 40) * 100);
    $progressMax = 50;
}

// Generate top investors data for the scrolling marquee
 $topInvestors = [
    ["name" => "Alex Johnson", "amount" => "₦125,000"],
    ["name" => "Sarah Williams", "amount" => "₦98,500"],
    ["name" => "Michael Chen", "amount" => "₦87,200"],
    ["name" => "Emma Thompson", "amount" => "₦76,800"],
    ["name" => "David Wilson", "amount" => "₦65,400"],
    ["name" => "Olivia Martinez", "amount" => "₦58,900"],
    ["name" => "James Anderson", "amount" => "₦52,300"],
    ["name" => "Sophia Taylor", "amount" => "₦47,600"],
    ["name" => "William Brown", "amount" => "₦43,200"],
    ["name" => "Isabella Davis", "amount" => "₦39,800"],
    ["name" => "Benjamin Miller", "amount" => "₦36,500"],
    ["name" => "Mia Wilson", "amount" => "₦33,200"],
    ["name" => "Lucas Moore", "amount" => "₦30,700"],
    ["name" => "Charlotte Taylor", "amount" => "₦28,400"],
    ["name" => "Henry Jackson", "amount" => "₦26,100"],
    ["name" => "Amelia White", "amount" => "₦24,800"],
    ["name" => "Ethan Harris", "amount" => "₦22,500"],
    ["name" => "Harper Martin", "amount" => "₦20,900"],
    ["name" => "Mason Thompson", "amount" => "₦19,300"],
    ["name" => "Evelyn Clark", "amount" => "₦17,800"]
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="<?php echo $sitedesc ?>">
    <title><?php echo $ptitle ?> - <?php echo $sitename ?></title>
    <link rel="shortcut icon" href="../favicon.png">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        :root {
            /* Gainmart colors */
            --primary-blue: #75AFEE;
            --dark-blue: #4A8FE7;
            --darker-blue: #2E6CBF;
            --black: #000000;
            --dark-gray: #1A1A1A;
            --medium-gray: #2A2A2A;
            --light-gray: #3A3A3A;
            --text-light: #E0E0E0;
            --text-dim: #A0A0A0;
            --card-bg: #1F1F1F;
            --card-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
            --input-bg: #2A2A2A;
            --border-color: #3A3A3A;
            --success: #4CAF50;
            --warning: #FFC107;
            --danger: #F44336;
            --telegram-blue: #0088cc;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background-color: var(--black);
            color: var(--text-light);
            transition: all 0.3s ease;
            min-height: 100vh;
            padding-bottom: 5rem; /* Added padding for bottom nav */
        }

        h1,h2,h3,h4,h5,h6 {
            font-weight: 700;
        }
        
        .container-fluid {
            width: 100%;
            padding-right: 15px;
            padding-left: 15px;
            margin-right: auto;
            margin-left: auto;
        }

        .row {
            display: flex;
            flex-wrap: wrap;
            margin-right: -15px;
            margin-left: -15px;
        }

        .col-12 {
            position: relative;
            width: 100%;
            padding-right: 15px;
            padding-left: 15px;
        }

        .g-gs {
            --bs-gutter-x: 1.5rem;
            --bs-gutter-y: 0;
            display: flex;
            flex-wrap: wrap;
            margin-top: calc(-1 * var(--bs-gutter-y));
            margin-right: calc(-.5 * var(--bs-gutter-x));
            margin-left: calc(-.5 * var(--bs-gutter-x));
        }

        .g-gs > * {
            flex-shrink: 0;
            width: 100%;
            max-width: 100%;
            padding-right: calc(var(--bs-gutter-x) * .5);
            padding-left: calc(var(--bs-gutter-x) * .5);
            margin-top: var(--bs-gutter-y);
        }

        .mt-3 {
            margin-top: 1rem !important;
        }

        .mt-4 {
            margin-top: 1.5rem !important;
        }

        .px-3 {
            padding-left: 1rem !important;
            padding-right: 1rem !important;
        }

        .mb-3 {
            margin-bottom: 1rem !important;
        }

        .mr-2 {
            margin-right: 0.5rem !important;
        }

        /* Header Styles */
        .header {
            background: var(--dark-gray);
            backdrop-filter: blur(10px);
            padding: 1rem 1.5rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .logo img {
            height: 40px;
        }

        .logo-text {
            font-size: 1.5rem;
            font-weight: 800;
            color: var(--primary-blue);
        }

        .header-actions {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .notification-btn {
            position: relative;
            background: var(--medium-gray);
            border: none;
            color: var(--text-light);
            font-size: 1.2rem;
            cursor: pointer;
            padding: 0.75rem;
            border-radius: 50%;
            transition: all 0.3s ease;
        }

        .notification-btn:hover {
            background: var(--light-gray);
            color: var(--primary-blue);
        }

        .notification-badge {
            position: absolute;
            top: 0;
            right: 0;
            width: 10px;
            height: 10px;
            background: var(--danger);
            border-radius: 50%;
        }

        .account-section {
            position: relative;
        }

        .account-btn {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            background: var(--medium-gray);
            border: none;
            color: var(--text-light);
            cursor: pointer;
            padding: 0.5rem 1rem;
            border-radius: 2rem;
            transition: all 0.3s ease;
        }

        .account-btn:hover {
            background: var(--light-gray);
        }

        .account-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid var(--primary-blue);
        }

        .account-info {
            display: flex;
            flex-direction: column;
            align-items: flex-start;
        }

        .account-name {
            font-weight: 600;
            font-size: 0.9rem;
        }

        .account-username {
            font-size: 0.8rem;
            color: var(--text-dim);
        }

        .account-dropdown {
            position: absolute;
            top: 100%;
            right: 0;
            margin-top: 0.5rem;
            background: var(--dark-gray);
            backdrop-filter: blur(10px);
            border-radius: 0.75rem;
            box-shadow: 0 10px 25px rgba(0,0,0,0.4);
            min-width: 220px;
            overflow: hidden;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
            transition: all 0.3s ease;
        }

        .account-dropdown.active {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        .dropdown-divider {
            height: 1px;
            background: var(--light-gray);
            margin: 0.5rem 0;
        }

        .dropdown-item {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem 1rem;
            color: var(--text-light);
            text-decoration: none;
            transition: background-color 0.3s;
        }

        .dropdown-item:hover {
            background-color: var(--medium-gray);
        }

        .dropdown-item i {
            font-size: 1.1rem;
            width: 20px;
            text-align: center;
            color: var(--primary-blue);
        }

        /* Bottom Navigation Bar */
        .bottom-navigation {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: var(--dark-gray);
            box-shadow: 0 -2px 10px rgba(0,0,0,0.2);
            z-index: 100;
            padding: 0.75rem 0;
            display: flex;
            justify-content: space-around;
            align-items: center;
        }

        .bottom-nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 0.5rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
            color: var(--text-dim);
            text-decoration: none;
            width: 20%;
        }

        .bottom-nav-item:hover {
            background: var(--medium-gray);
            color: var(--primary-blue);
        }

        .bottom-nav-item.active {
            background: var(--medium-gray);
            color: var(--primary-blue);
        }

        .bottom-nav-icon {
            font-size: 1.5rem;
            margin-bottom: 0.25rem;
        }

        .bottom-nav-text {
            font-size: 0.7rem;
            font-weight: 600;
        }

        /* Right Sidebar Menu */
        .right-sidebar {
            position: fixed;
            top: 0;
            right: -50%; /* Hidden by default - half page width */
            width: 50%; /* Half page width */
            height: 100%;
            background: var(--dark-gray);
            z-index: 1001;
            transition: right 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
            overflow-y: auto;
            box-shadow: -5px 0 25px rgba(0,0,0,0.4);
        }

        .right-sidebar.active {
            right: 0;
        }

        .sidebar-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 1.5rem;
            border-bottom: 1px solid var(--light-gray);
            position: relative;
            z-index: 2;
            background: var(--dark-gray);
        }

        .sidebar-logo {
            height: 40px;
            filter: drop-shadow(0 2px 4px rgba(0,0,0,0.3));
        }

        .sidebar-close {
            background: var(--medium-gray);
            border: none;
            color: var(--text-light);
            font-size: 1.5rem;
            cursor: pointer;
            padding: 0.5rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
        }

        .sidebar-close:hover {
            background: var(--light-gray);
            transform: rotate(90deg);
        }

        .sidebar-content {
            padding: 1rem 0;
            position: relative;
            z-index: 2;
            background: var(--dark-gray);
            min-height: calc(100% - 73px); /* Subtract header height */
        }

        .nk-menu {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .nk-menu-item {
            margin: 0.25rem 0;
            opacity: 0;
            transform: translateX(20px);
            animation: slideInRight 0.5s forwards;
        }

        /* Stagger animation for menu items */
        .nk-menu-item:nth-child(1) { animation-delay: 0.1s; }
        .nk-menu-item:nth-child(2) { animation-delay: 0.15s; }
        .nk-menu-item:nth-child(3) { animation-delay: 0.2s; }
        .nk-menu-item:nth-child(4) { animation-delay: 0.25s; }
        .nk-menu-item:nth-child(5) { animation-delay: 0.3s; }
        .nk-menu-item:nth-child(6) { animation-delay: 0.35s; }
        .nk-menu-item:nth-child(7) { animation-delay: 0.4s; }
        .nk-menu-item:nth-child(8) { animation-delay: 0.45s; }
        .nk-menu-item:nth-child(9) { animation-delay: 0.5s; }
        .nk-menu-item:nth-child(10) { animation-delay: 0.55s; }
        .nk-menu-item:nth-child(11) { animation-delay: 0.6s; }
        .nk-menu-item:nth-child(12) { animation-delay: 0.65s; }
        .nk-menu-item:nth-child(13) { animation-delay: 0.7s; }
        .nk-menu-item:nth-child(14) { animation-delay: 0.75s; }
        .nk-menu-item:nth-child(15) { animation-delay: 0.8s; }

        @keyframes slideInRight {
            from {
                opacity: 0;
                transform: translateX(20px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        .nk-menu-link {
            display: flex;
            align-items: center;
            padding: 0.9rem 1.5rem;
            color: var(--text-light);
            text-decoration: none;
            transition: all 0.3s ease;
            border-radius: 0.75rem;
            margin: 0 0.75rem;
            position: relative;
            overflow: hidden;
        }

        .nk-menu-link::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 4px;
            height: 100%;
            background: var(--primary-blue);
            transform: scaleY(0);
            transition: transform 0.3s ease;
        }

        .nk-menu-link:hover {
            background: var(--medium-gray);
            transform: translateX(5px);
        }

        .nk-menu-link:hover::before {
            transform: scaleY(1);
        }

        .nk-menu-icon {
            margin-right: 1rem;
            color: var(--primary-blue);
            font-size: 1.2rem;
            width: 24px;
            text-align: center;
            transition: transform 0.3s ease;
        }

        .nk-menu-link:hover .nk-menu-icon {
            transform: scale(1.1);
        }

        .nk-menu-text {
            font-weight: 500;
            font-size: 1rem;
        }

        .nk-menu-heading {
            padding: 0.75rem 1.5rem;
            margin: 1.5rem 0 0.75rem;
            color: var(--text-dim);
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 0.1em;
            position: relative;
        }

        .nk-menu-heading::after {
            content: '';
            position: absolute;
            bottom: -0.5rem;
            left: 1.5rem;
            right: 1.5rem;
            height: 1px;
            background: var(--light-gray);
        }

        .overline-title {
            font-weight: 600;
        }

        .nk-menu-sub {
            list-style: none;
            padding: 0;
            margin: 0.25rem 0 0.25rem 2rem;
            background: var(--black);
            border-radius: 0.75rem;
            overflow: hidden;
            max-height: 0;
            opacity: 0;
            transition: all 0.4s ease;
        }

        .nk-menu-sub.active {
            max-height: 500px;
            opacity: 1;
        }

        .nk-menu-sub .nk-menu-item {
            margin: 0;
            opacity: 1;
            transform: none;
            animation: none;
        }

        .nk-menu-sub .nk-menu-link {
            padding: 0.7rem 1rem 0.7rem 1.5rem;
            font-size: 0.9rem;
            border-radius: 0.5rem;
            margin: 0.25rem 0.75rem;
        }

        .nk-menu-sub .nk-menu-link::before {
            width: 3px;
        }

        .nk-menu-sub .nk-menu-icon {
            font-size: 1rem;
            margin-right: 0.75rem;
        }

        /* Menu toggle icon animation */
        .nk-menu-toggle .nk-menu-icon::after {
            content: '\f107';
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            margin-left: auto;
            transition: transform 0.3s ease;
        }

        .nk-menu-toggle.active .nk-menu-icon::after {
            transform: rotate(180deg);
        }

        /* Overlay for sidebar */
        .sidebar-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.7);
            z-index: 1000;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        .sidebar-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        /* Main Dashboard Styles */
        .dashboard-welcome {
            margin-bottom: 1.5rem;
        }

        .dashboard-welcome h5 {
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--text-light);
        }

        /* Wallet balance card */
        .wallet-card {
            background: linear-gradient(135deg, var(--dark-gray) 0%, var(--medium-gray) 100%);
            border-radius: 1rem;
            padding: 2rem;
            box-shadow: var(--card-shadow);
            margin-bottom: 1.5rem;
            position: relative;
            overflow: hidden;
        }

        .wallet-card::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 150px;
            height: 150px;
            background: var(--primary-blue);
            opacity: 0.1;
            border-radius: 50%;
            transform: translate(50px, -50px);
        }

        .wallet-card::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100px;
            height: 100px;
            background: var(--primary-blue);
            opacity: 0.1;
            border-radius: 50%;
            transform: translate(-30px, 30px);
        }

        .wallet-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
            position: relative;
            z-index: 1;
        }

        .wallet-title {
            font-size: 0.9rem;
            font-weight: 600;
            color: var(--text-dim);
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        .wallet-package {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            background: rgba(117, 175, 238, 0.15);
            padding: 0.4rem 0.8rem;
            border-radius: 2rem;
        }

        .package-icon {
            color: var(--primary-blue);
            font-size: 1rem;
        }

        .package-name {
            font-size: 0.8rem;
            font-weight: 600;
            color: var(--primary-blue);
        }

        .wallet-amount {
            font-size: 2.5rem;
            font-weight: 800;
            color: var(--text-light);
            margin-bottom: 0.5rem;
            position: relative;
            z-index: 1;
        }

        .wallet-actions {
            display: flex;
            gap: 1rem;
            position: relative;
            z-index: 1;
        }

        .wallet-btn {
            flex: 1;
            padding: 0.8rem;
            border-radius: 0.5rem;
            font-weight: 600;
            text-align: center;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .wallet-btn-primary {
            background: var(--primary-blue);
            color: var(--black);
        }

        .wallet-btn-primary:hover {
            background: var(--dark-blue);
            transform: translateY(-2px);
        }

        .wallet-btn-secondary {
            background: var(--medium-gray);
            color: var(--text-light);
            border: 1px solid var(--light-gray);
        }

        .wallet-btn-secondary:hover {
            background: var(--light-gray);
            transform: translateY(-2px);
        }

        /* Stats Cards */
        .stats-container {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 1rem;
            margin-bottom: 1.5rem;
        }

        .stat-card {
            background: var(--dark-gray);
            border-radius: 0.75rem;
            padding: 1.25rem;
            box-shadow: var(--card-shadow);
            transition: transform 0.3s ease;
        }

        .stat-card:hover {
            transform: translateY(-5px);
        }

        .stat-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 0.75rem;
        }

        .stat-title {
            font-size: 0.85rem;
            font-weight: 600;
            color: var(--text-dim);
        }

        .stat-icon {
            width: 36px;
            height: 36px;
            border-radius: 0.5rem;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
        }

        .stat-icon.primary {
            background: rgba(117, 175, 238, 0.15);
            color: var(--primary-blue);
        }

        .stat-icon.success {
            background: rgba(76, 175, 80, 0.15);
            color: var(--success);
        }

        .stat-value {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--text-light);
            margin-bottom: 0.25rem;
        }

        .stat-change {
            font-size: 0.75rem;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 0.25rem;
        }

        .stat-change.positive {
            color: var(--success);
        }

        .stat-change.negative {
            color: var(--danger);
        }

        /* Quick Actions */
        .quick-actions {
            background: var(--dark-gray);
            border-radius: 0.75rem;
            padding: 1.25rem;
            margin-bottom: 1.5rem;
            box-shadow: var(--card-shadow);
        }

        .section-title {
            font-size: 1rem;
            font-weight: 700;
            color: var(--text-light);
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .section-title i {
            color: var(--primary-blue);
        }

        .actions-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 1rem;
        }

        .action-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 0.5rem;
            padding: 1rem;
            border-radius: 0.5rem;
            background: var(--medium-gray);
            text-decoration: none;
            color: var(--text-light);
            transition: all 0.3s ease;
        }

        .action-item:hover {
            background: var(--light-gray);
            transform: translateY(-3px);
        }

        .action-icon {
            width: 48px;
            height: 48px;
            border-radius: 50%;
            background: var(--black);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.25rem;
            color: var(--primary-blue);
        }

        .action-label {
            font-size: 0.75rem;
            font-weight: 600;
            text-align: center;
        }

        /* Referral Section */
        .referral-section {
            background: var(--dark-gray);
            border-radius: 0.75rem;
            padding: 1.25rem;
            margin-bottom: 1.5rem;
            box-shadow: var(--card-shadow);
        }

        .referral-header {
            margin-bottom: 1rem;
        }

        .referral-description {
            font-size: 0.85rem;
            color: var(--text-dim);
            margin-bottom: 1rem;
        }

        .referral-link-container {
            display: flex;
            margin-bottom: 1.5rem;
        }

        .referral-input {
            flex: 1;
            background: var(--medium-gray);
            border: 1px solid var(--light-gray);
            border-radius: 0.5rem 0 0 0.5rem;
            padding: 0.75rem;
            color: var(--text-light);
            font-size: 0.85rem;
        }

        .copy-btn {
            background: var(--primary-blue);
            color: var(--black);
            border: none;
            border-radius: 0 0.5rem 0.5rem 0;
            padding: 0 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .copy-btn:hover {
            background: var(--dark-blue);
        }

        /* Top Investors Marquee */
        .top-investors {
            margin-top: 1.5rem;
        }

        .marquee-container {
            background: var(--medium-gray);
            border-radius: 0.5rem;
            overflow: hidden;
            position: relative;
        }

        .marquee {
            display: flex;
            animation: scroll 30s linear infinite;
        }

        .marquee-item {
            flex: 0 0 auto;
            width: 200px;
            padding: 0.75rem;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            border-right: 1px solid var(--light-gray);
        }

        .marquee-item:last-child {
            border-right: none;
        }

        .investor-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: var(--primary-blue);
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 0.5rem;
            font-weight: 700;
            color: var(--black);
        }

        .investor-name {
            font-size: 0.8rem;
            font-weight: 600;
            margin-bottom: 0.25rem;
            text-align: center;
        }

        .investor-amount {
            font-size: 0.75rem;
            color: var(--primary-blue);
            font-weight: 700;
        }

        @keyframes scroll {
            0% {
                transform: translateX(0);
            }
            100% {
                transform: translateX(-50%);
            }
        }

        /* Referral Progress */
        .referral-progress {
            margin-top: 1rem;
        }

        .badge-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 0.75rem;
        }

        .current-badge {
            display: flex;
            align-items: center;
            font-weight: 600;
            color: var(--text-light);
            font-size: 0.9rem;
        }

        .badge-icon {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 24px;
            height: 24px;
            border-radius: 50%;
            margin-right: 0.5rem;
            background-color: <?php echo $badgeColor; ?>;
        }

        .next-badge {
            font-size: 0.8rem;
            color: var(--text-dim);
        }

        .progress-container {
            background-color: var(--medium-gray);
            height: 8px;
            border-radius: 10px;
            overflow: hidden;
            margin-bottom: 0.5rem;
        }

        .progress-bar {
            height: 100%;
            background-color: <?php echo $badgeColor; ?>;
            border-radius: 10px;
            width: <?php echo $progressPercentage; ?>%;
            transition: width 1s ease-in-out;
        }

        .progress-text {
            display: flex;
            justify-content: space-between;
            font-size: 0.8rem;
            color: var(--text-dim);
        }

        .progress-current {
            font-weight: 600;
        }

        .progress-max {
            color: var(--text-dim);
        }

        .referral-stats {
            display: flex;
            justify-content: space-between;
            margin-top: 1rem;
        }

        .referral-stat {
            text-align: center;
        }

        .referral-stat-value {
            font-size: 1.1rem;
            font-weight: 700;
            color: var(--primary-blue);
        }

        .referral-stat-label {
            font-size: 0.7rem;
            color: var(--text-dim);
        }

        /* Copy notification */
        .copy-notification {
            position: fixed;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            background-color: var(--primary-blue);
            color: var(--black);
            padding: 12px 24px;
            border-radius: 8px;
            z-index: 9999;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            opacity: 1;
            transition: opacity 0.5s;
            font-weight: 600;
        }

        /* Telegram Popup Styles */
        .telegram-popup-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.8);
            z-index: 9998;
            display: flex;
            justify-content: center;
            align-items: center;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        .telegram-popup-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        .telegram-popup {
            background-color: var(--dark-gray);
            border-radius: 1rem;
            width: 90%;
            max-width: 450px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.5);
            transform: scale(0.8);
            transition: transform 0.3s ease;
        }

        .telegram-popup-overlay.active .telegram-popup {
            transform: scale(1);
        }

        .telegram-popup-header {
            background-color: var(--telegram-blue);
            padding: 1.5rem;
            text-align: center;
            color: white;
        }

        .telegram-popup-header h3 {
            font-size: 1.5rem;
            margin-bottom: 0.5rem;
        }

        .telegram-popup-header p {
            font-size: 0.9rem;
            opacity: 0.9;
        }

        .telegram-popup-body {
            padding: 2rem;
            text-align: center;
        }

        .telegram-icon {
            font-size: 4rem;
            color: var(--telegram-blue);
            margin-bottom: 1rem;
        }

        .telegram-popup-body p {
            margin-bottom: 1.5rem;
            color: var(--text-light);
            line-height: 1.6;
        }

        .telegram-popup-actions {
            display: flex;
            gap: 1rem;
            justify-content: center;
        }

        .telegram-btn {
            padding: 0.75rem 1.5rem;
            border-radius: 0.5rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            border: none;
            font-size: 1rem;
            text-decoration: none;
            display: inline-block;
        }

        .telegram-btn-primary {
            background-color: var(--telegram-blue);
            color: white;
        }

        .telegram-btn-primary:hover {
            background-color: #0077b5;
            transform: translateY(-2px);
        }

        .telegram-btn-secondary {
            background-color: var(--medium-gray);
            color: var(--text-light);
            border: 1px solid var(--light-gray);
        }

        .telegram-btn-secondary:hover {
            background-color: var(--light-gray);
            transform: translateY(-2px);
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .header {
                padding: 0.75rem 1rem;
            }
            
            .logo-text {
                font-size: 1.2rem;
            }
            
            .account-info {
                display: none;
            }
            
            .right-sidebar {
                width: 80%; /* 80% width on mobile instead of 50% */
                right: -80%;
            }
            
            .wallet-amount {
                font-size: 2rem;
            }
            
            .actions-grid {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .badge-container {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .next-badge {
                margin-top: 0.25rem;
            }
            
            .bottom-nav-text {
                font-size: 0.6rem;
            }
            
            .telegram-popup {
                width: 95%;
            }
            
            .telegram-popup-actions {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <div class="logo">
            <img src="/g1.jpg" alt="Gainmart Logo">
            <div class="logo-text">Gainmart</div>
        </div>
        <div class="header-actions">
            <div class="account-section">
                <button class="account-btn" id="accountBtn">
                    <img src="/g1.jpg" alt="Profile" class="account-avatar">
                    <div class="account-info">
                        <span class="account-name"><?php echo $fullname ?></span>
                        <span class="account-username">@<?php echo $username ?></span>
                    </div>
                    <i class="fas fa-chevron-down"></i>
                </button>
                
                <div class="account-dropdown" id="accountDropdown">
                    <a href="settings" class="dropdown-item">
                        <i class="fas fa-cog"></i>
                        <span>Settings</span>
                    </a>
                    <div class="dropdown-divider"></div>
                    <a href="logout" class="dropdown-item">
                        <i class="fas fa-sign-out-alt"></i>
                        <span>Log Out</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Right Sidebar Menu -->
    <div class="right-sidebar" id="rightSidebar">
        <div class="sidebar-header">
            <img src="favicon.png" alt="Logo" class="sidebar-logo">
            <button class="sidebar-close" id="sidebarClose">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <div class="sidebar-content">
            <div class="nk-sidebar-menu" data-simplebar>
                <ul class="nk-menu">
                    <li class="nk-menu-item">
                        <a href="../user/index" class="nk-menu-link">
                            <span class="nk-menu-icon"><i class="fas fa-home"></i></span>
                            <span class="nk-menu-text">Dashboard</span>
                        </a>
                    </li>
                    <li class="nk-menu-heading">
                        <h6 class="overline-title">MENU</h6>
                    </li>
                    <li class="nk-menu-item">
                        <a href="user_packages.php" class="nk-menu-link">
                            <span class="nk-menu-icon"><i class="fas fa-box"></i></span>
                            <span class="nk-menu-text">Investment Packages</span>
                        </a>
                    </li>
                    <li class="nk-menu-item">
                        <a href="user_withdrawal.php" class="nk-menu-link">
                            <span class="nk-menu-icon"><i class="fas fa-money-bill-wave"></i></span>
                            <span class="nk-menu-text">Withdraw Funds</span>
                        </a>
                    </li>
                    <li class="nk-menu-item">
                        <a href="referrals" class="nk-menu-link">
                            <span class="nk-menu-icon"><i class="fas fa-users"></i></span>
                            <span class="nk-menu-text">My Referrals</span>
                        </a>
                    </li>
                    <li class="nk-menu-item">
                        <a href="settings" class="nk-menu-link">
                            <span class="nk-menu-icon"><i class="fas fa-cog"></i></span>
                            <span class="nk-menu-text">Account Settings</span>
                        </a>
                    </li>
                    
                    <div class="mt-5"></div>
                </ul>
            </div>
        </div>
    </div>

    <!-- Sidebar Overlay -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <div class="nk-content px-0">
        <div class="container-fluid">
            <div class="nk-content-inner">
                <div class="nk-content-body">
                    <div class="row g-gs">

                        <div class="col-12 px-3 mt-4">
                            <div class="dashboard-welcome">
                                <h5>Welcome back, <?php echo $username ?></h5>
                            </div>
                        </div>

                        <!-- Wallet balance card -->
                        <div class="col-12 mt-3">
                            <div class="wallet-card">
                                <div class="wallet-header">
                                    <div class="wallet-title">Total Balance</div>
                                    <div class="wallet-package">
                                        <i class="<?php echo $packageIcon; ?> package-icon"></i>
                                        <span class="package-name"><?php echo $package; ?></span>
                                    </div>
                                </div>
                                <div class="wallet-amount">₦<?php echo number_format((int)$funds,2) ?></div>
                                <div class="wallet-actions">
                                    <a href="user_deposit.php" class="wallet-btn wallet-btn-primary">Deposit</a>
                                    <a href="user_withdrawal.php" class="wallet-btn wallet-btn-secondary">Withdraw</a>
                                </div>
                            </div>
                        </div>

                        <!-- Stats Cards -->
                        <div class="col-12 mt-3">
                            <div class="stats-container">
                                <div class="stat-card">
                                    <div class="stat-header">
                                        <div class="stat-title">Activity Earnings</div>
                                        <div class="stat-icon primary">
                                            <i class="fas fa-chart-line"></i>
                                        </div>
                                    </div>
                                    <div class="stat-value">₦<?php echo number_format((int)$funds,2) ?></div>
                                    <div class="stat-change positive">
                                        <i class="fas fa-arrow-up"></i>
                                        <span>12.5% from last week</span>
                                    </div>
                                </div>
                                <div class="stat-card">
                                    <div class="stat-header">
                                        <div class="stat-title">Referral Balance</div>
                                        <div class="stat-icon success">
                                            <i class="fas fa-users"></i>
                                        </div>
                                    </div>
                                    <div class="stat-value">₦<?php echo number_format((int)$referralFunds,2) ?></div>
                                    <div class="stat-change positive">
                                        <i class="fas fa-arrow-up"></i>
                                        <span><?php echo number_format((int)$totalReferrals) ?> referrals</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Quick Actions -->
                        <div class="col-12 mt-3">
                            <div class="quick-actions">
                                <div class="section-title">
                                    <i class="fas fa-bolt"></i>
                                    <span>Quick Actions</span>
                                </div>
                                <div class="actions-grid">
                                   <a href="user_withdrawal.php" class="action-item">
                                        <div class="action-icon">
                                            <i class="fas fa-bank"></i>
                                        </div>
                                        <div class="action-label">Withdrawal</div>
                                    </a>
                                    <a href="settings.php" class="action-item">
                                        <div class="action-icon">
                                            <i class="fas fa-cog"></i>
                                        </div>
                                        <div class="action-label">Settings</div>
                                    </a>
                                    <a href="user_packages.php" class="action-item">
                                        <div class="action-icon">
                                            <i class="fas fa-box"></i>
                                        </div>
                                        <div class="action-label">Packages</div>
                                    </a>
                                    <a href="user_deposit.php" class="action-item">
                                        <div class="action-icon">
                                            <i class="fas fa-money-bill-wave"></i>
                                        </div>
                                        <div class="action-label">Deposit</div>
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Referral Section -->
                        <div class="col-12 mt-3">
                            <div class="referral-section">
                                <div class="referral-header">
                                    <div class="section-title">
                                        <i class="fas fa-share-alt"></i>
                                        <span>Refer & Earn</span>
                                    </div>
                                </div>
                                <p class="referral-description">Share your referral link and earn bonuses for every friend that joins.</p>
                                
                                <div class="referral-link-container">
                                    <input type="text" id="refUrl" readonly value="https://gainmart.top/register?ref=<?php echo $username ?>" class="referral-input">
                                    <button id="copyButton" class="copy-btn">Copy</button>
                                </div>
                                
                                <!-- Referral Progress Bar -->
                                <div class="referral-progress">
                                    <div class="badge-container">
                                        <div class="current-badge">
                                            <span class="badge-icon">
                                                <i class="fas fa-star"></i>
                                            </span>
                                            <span>Your Badge: <?php echo $referralBadge; ?></span>
                                        </div>
                                        <div class="next-badge">Next: <?php echo $nextBadge; ?></div>
                                    </div>
                                    
                                    <div class="progress-container">
                                        <div class="progress-bar"></div>
                                    </div>
                                    
                                    <div class="progress-text">
                                        <span class="progress-current"><?php echo $totalReferrals; ?> referrals</span>
                                        <span class="progress-max"><?php echo $progressMax; ?> referrals</span>
                                    </div>
                                </div>
                                
                                <!-- Top Investors Marquee -->
                                <div class="top-investors">
                                    <div class="section-title">
                                        <i class="fas fa-trophy"></i>
                                        <span>Top Investors</span>
                                    </div>
                                    <div class="marquee-container">
                                        <div class="marquee">
                                            <?php foreach($topInvestors as $investor): ?>
                                                <div class="marquee-item">
                                                    <div class="investor-avatar"><?php echo strtoupper(substr($investor['name'], 0, 1)); ?></div>
                                                    <div class="investor-name"><?php echo $investor['name']; ?></div>
                                                    <div class="investor-amount"><?php echo $investor['amount']; ?></div>
                                                </div>
                                            <?php endforeach; ?>
                                            <!-- Duplicate items for seamless scrolling -->
                                            <?php foreach($topInvestors as $investor): ?>
                                                <div class="marquee-item">
                                                    <div class="investor-avatar"><?php echo strtoupper(substr($investor['name'], 0, 1)); ?></div>
                                                    <div class="investor-name"><?php echo $investor['name']; ?></div>
                                                    <div class="investor-amount"><?php echo $investor['amount']; ?></div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="referral-stats">
                                    <div class="referral-stat">
                                        <div class="referral-stat-value"><?php echo $totalReferrals; ?></div>
                                        <div class="referral-stat-label">Total Referrals</div>
                                    </div>
                                    <div class="referral-stat">
                                        <div class="referral-stat-value">₦<?php echo number_format((int)$referralFunds,2) ?></div>
                                        <div class="referral-stat-label">Referral Balance</div>
                                    </div>
                                    <div class="referral-stat">
                                        <div class="referral-stat-value"><?php echo $referralBadge; ?></div>
                                        <div class="referral-stat-label">Current Badge</div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bottom Navigation Bar -->
    <div class="bottom-navigation">
        <a href="../user/index" class="bottom-nav-item active">
            <i class="fas fa-home bottom-nav-icon"></i>
            <span class="bottom-nav-text">Dashboard</span>
        </a>
        <a href="user_packages.php" class="bottom-nav-item">
            <i class="fas fa-box bottom-nav-icon"></i>
            <span class="bottom-nav-text">Packages</span>
        </a>
        <a href="user_withdrawal.php" class="bottom-nav-item">
            <i class="fas fa-money-bill-wave bottom-nav-icon"></i>
            <span class="bottom-nav-text">Withdraw</span>
        </a>
        <a href="referrals" class="bottom-nav-item">
            <i class="fas fa-users bottom-nav-icon"></i>
            <span class="bottom-nav-text">Referrals</span>
        </a>
        <a href="settings" class="bottom-nav-item">
            <i class="fas fa-cog bottom-nav-icon"></i>
            <span class="bottom-nav-text">Settings</span>
        </a>
    </div>

    <!-- Telegram Popup -->
    <div class="telegram-popup-overlay" id="telegramPopup">
        <div class="telegram-popup">
            <div class="telegram-popup-header">
                <h3>Join Our Telegram Channel</h3>
                <p>Stay updated with the latest news and announcements</p>
            </div>
            <div class="telegram-popup-body">
                <div class="telegram-icon">
                    <i class="fab fa-telegram-plane"></i>
                </div>
                <p>Join our Telegram community to get real-time updates, investment tips, and exclusive offers available only to our members.</p>
                <div class="telegram-popup-actions">
                    <a href="https://t.me/+Q9dEw9vFa4MxYzhk" target="_blank" class="telegram-btn telegram-btn-primary">Join Now</a>
                    <button id="closeTelegramPopup" class="telegram-btn telegram-btn-secondary">Not Now</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Audio element for slide sound -->
    <audio id="slideSound" src="https://assets.mixkit.co/sfx/preview/mixkit-select-click-1109.mp3" preload="auto"></audio>

    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <script>
        // New copy referral link functionality
        function copyReferralLink() {
            // Get the referral link input element
            const refUrlInput = document.getElementById('refUrl');
            
            // Check if input exists
            if (!refUrlInput) {
                console.error('Referral URL input not found');
                return;
            }
            
            // Get the referral link value
            const refUrl = refUrlInput.value;
            
            // Create a temporary textarea element to copy the text
            const tempTextArea = document.createElement('textarea');
            tempTextArea.value = refUrl;
            
            // Make the textarea invisible
            tempTextArea.style.position = 'fixed';
            tempTextArea.style.left = '-999999px';
            tempTextArea.style.top = '-999999px';
            tempTextArea.style.width = '2em';
            tempTextArea.style.height = '2em';
            tempTextArea.style.padding = '0';
            tempTextArea.style.border = 'none';
            tempTextArea.style.outline = 'none';
            tempTextArea.style.boxShadow = 'none';
            tempTextArea.style.background = 'transparent';
            
            // Add the textarea to the document
            document.body.appendChild(tempTextArea);
            
            // Select the text in the textarea
            tempTextArea.select();
            
            try {
                // Execute the copy command
                const successful = document.execCommand('copy');
                
                // Remove the textarea from the document
                document.body.removeChild(tempTextArea);
                
                if (successful) {
                    // Show success notification
                    showCopyNotification('Referral link copied to clipboard!', 'success');
                } else {
                    // Show error notification
                    showCopyNotification('Failed to copy referral link', 'error');
                }
            } catch (err) {
                // Remove the textarea from the document
                document.body.removeChild(tempTextArea);
                
                // Show error notification
                showCopyNotification('Failed to copy referral link', 'error');
                console.error('Copy error:', err);
            }
        }

        // Show copy notification
        function showCopyNotification(message, type = 'success') {
            // Check if notification already exists
            let notification = document.querySelector('.copy-notification');
            
            // If notification exists, remove it
            if (notification) {
                notification.remove();
            }
            
            // Create new notification
            notification = document.createElement('div');
            notification.className = 'copy-notification';
            notification.textContent = message;
            
            // Set background color based on type
            if (type === 'error') {
                notification.style.backgroundColor = 'var(--danger)';
            } else {
                notification.style.backgroundColor = 'var(--primary-blue)';
            }
            
            // Add the notification to the document
            document.body.appendChild(notification);
            
            // Remove notification after 3 seconds
            setTimeout(() => {
                notification.style.opacity = '0';
                setTimeout(() => {
                    if (notification.parentNode) {
                        notification.parentNode.removeChild(notification);
                    }
                }, 500);
            }, 3000);
        }

        // Account dropdown functionality
        document.addEventListener('DOMContentLoaded', function() {
            const accountBtn = document.getElementById('accountBtn');
            const accountDropdown = document.getElementById('accountDropdown');
            
            if (accountBtn && accountDropdown) {
                accountBtn.addEventListener('click', function(e) {
                    e.stopPropagation();
                    accountDropdown.classList.toggle('active');
                });
                
                // Close dropdown when clicking outside
                document.addEventListener('click', function() {
                    accountDropdown.classList.remove('active');
                });
                
                // Prevent dropdown from closing when clicking inside it
                accountDropdown.addEventListener('click', function(e) {
                    e.stopPropagation();
                });
            }
            
            const copyButton1 = document.getElementById('copyButton');
            
            if (copyButton1) {
                copyButton1.addEventListener('click', copyReferralLink);
            }
            
            // Right sidebar functionality
            const hamburgerBtn = document.getElementById('hamburgerBtn');
            const rightSidebar = document.getElementById('rightSidebar');
            const sidebarClose = document.getElementById('sidebarClose');
            const sidebarOverlay = document.getElementById('sidebarOverlay');
            
            if (hamburgerBtn && rightSidebar && sidebarClose && sidebarOverlay) {
                // Open sidebar when hamburger is clicked
                hamburgerBtn.addEventListener('click', function() {
                    rightSidebar.classList.add('active');
                    sidebarOverlay.classList.add('active');
                    document.body.style.overflow = 'hidden'; // Prevent body scroll when sidebar is open
                    
                    // Reset animations when opening
                    const menuItems = rightSidebar.querySelectorAll('.nk-menu-item');
                    menuItems.forEach(item => {
                        item.style.animation = 'none';
                        item.offsetHeight; // Trigger reflow
                        item.style.animation = null;
                    });
                });
                
                // Close sidebar when close button is clicked
                sidebarClose.addEventListener('click', function() {
                    rightSidebar.classList.remove('active');
                    sidebarOverlay.classList.remove('active');
                    document.body.style.overflow = ''; // Restore body scroll
                });
                
                // Close sidebar when overlay is clicked
                sidebarOverlay.addEventListener('click', function() {
                    rightSidebar.classList.remove('active');
                    sidebarOverlay.classList.remove('active');
                    document.body.style.overflow = ''; // Restore body scroll
                });
                
                // Handle submenu toggles
                const menuToggles = document.querySelectorAll('.nk-menu-toggle');
                menuToggles.forEach(toggle => {
                    toggle.addEventListener('click', function(e) {
                        e.preventDefault();
                        const parentItem = this.parentElement;
                        const submenu = parentItem.querySelector('.nk-menu-sub');
                        
                        if (submenu) {
                            submenu.classList.toggle('active');
                            this.classList.toggle('active');
                        }
                    });
                });
            }
            
            // Set active navigation item based on current page
            const currentPath = window.location.pathname;
            const navItems = document.querySelectorAll('.bottom-nav-item');
            
            navItems.forEach(item => {
                const itemPath = item.getAttribute('href');
                if (currentPath.includes(itemPath)) {
                    item.classList.add('active');
                } else {
                    item.classList.remove('active');
                }
            });
            
            // Telegram popup functionality
            const telegramPopup = document.getElementById('telegramPopup');
            const closeTelegramPopup = document.getElementById('closeTelegramPopup');
            
            // Show popup after page load
            setTimeout(() => {
                telegramPopup.classList.add('active');
            }, 1000); // Show after 3 seconds
            
            // Close popup when "Not Now" button is clicked
            if (closeTelegramPopup) {
                closeTelegramPopup.addEventListener('click', function() {
                    telegramPopup.classList.remove('active');
                });
            }
            
            // Close popup when clicking outside the popup
            telegramPopup.addEventListener('click', function(e) {
                if (e.target === telegramPopup) {
                    telegramPopup.classList.remove('active');
                }
            });
        });
    </script>
</body>
</html>