<?php
require $_SERVER['DOCUMENT_ROOT'] . "/stream.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/user/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/user/actions/profile.php";
 $ptitle = "Account Settings";

// Determine referral badge based on number of referrals
if ($totalReferrals < 1) {
    $referralBadge = "None";
    $badgeColor = "#6c757d"; // Gray
    $nextBadge = "Beginner";
    $progressPercentage = 0;
    $progressMax = 1;
} elseif ($totalReferrals < 10) {
    $referralBadge = "Beginner";
    $badgeColor = "#75AFEE"; // Gainmart blue
    $nextBadge = "Vendor";
    $progressPercentage = ($totalReferrals / 10) * 100;
    $progressMax = 10;
} else {
    $referralBadge = "Vendor";
    $badgeColor = "#75AFEE"; // Gainmart blue
    $nextBadge = "Expert";
    $progressPercentage = min(100, (($totalReferrals - 10) / 40) * 100);
    $progressMax = 50;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="<?php echo $sitedesc ?>">
    <title><?php echo $ptitle ?> - <?php echo $sitename ?></title>
    <link rel="shortcut icon" href="../favicon.png">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        :root {
            /* Gainmart colors */
            --primary-blue: #75AFEE;
            --dark-blue: #4A8FE7;
            --darker-blue: #2E6CBF;
            --black: #000000;
            --dark-gray: #1A1A1A;
            --medium-gray: #2A2A2A;
            --light-gray: #3A3A3A;
            --text-light: #E0E0E0;
            --text-dim: #A0A0A0;
            --card-bg: #1F1F1F;
            --card-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
            --input-bg: #2A2A2A;
            --border-color: #3A3A3A;
            --success: #4CAF50;
            --warning: #FFC107;
            --danger: #F44336;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background-color: var(--black);
            color: var(--text-light);
            transition: all 0.3s ease;
            min-height: 100vh;
            padding-bottom: 5rem; /* Added padding for bottom nav */
        }

        h1,h2,h3,h4,h5,h6 {
            font-weight: 700;
        }
        
        .container-fluid {
            width: 100%;
            padding-right: 15px;
            padding-left: 15px;
            margin-right: auto;
            margin-left: auto;
        }

        .row {
            display: flex;
            flex-wrap: wrap;
            margin-right: -15px;
            margin-left: -15px;
        }

        .col-12, .col-lg-4, .col-lg-6, .col-lg-12 {
            position: relative;
            width: 100%;
            padding-right: 15px;
            padding-left: 15px;
        }

        @media (min-width: 992px) {
            .col-lg-4 {
                flex: 0 0 33.333333%;
                max-width: 33.333333%;
            }
            .col-lg-6 {
                flex: 0 0 50%;
                max-width: 50%;
            }
            .col-lg-12 {
                flex: 0 0 100%;
                max-width: 100%;
            }
        }

        .g-gs {
            --bs-gutter-x: 1.5rem;
            --bs-gutter-y: 0;
            display: flex;
            flex-wrap: wrap;
            margin-top: calc(-1 * var(--bs-gutter-y));
            margin-right: calc(-.5 * var(--bs-gutter-x));
            margin-left: calc(-.5 * var(--bs-gutter-x));
        }

        .g-gs > * {
            flex-shrink: 0;
            width: 100%;
            max-width: 100%;
            padding-right: calc(var(--bs-gutter-x) * .5);
            padding-left: calc(var(--bs-gutter-x) * .5);
            margin-top: var(--bs-gutter-y);
        }

        .mt-3 {
            margin-top: 1rem !important;
        }

        .mt-4 {
            margin-top: 1.5rem !important;
        }

        .px-3 {
            padding-left: 1rem !important;
            padding-right: 1rem !important;
        }

        .mb-3 {
            margin-bottom: 1rem !important;
        }

        .mb-4 {
            margin-bottom: 1.5rem !important;
        }

        .mr-2 {
            margin-right: 0.5rem !important;
        }

        /* Header Styles */
        .header {
            background: var(--dark-gray);
            backdrop-filter: blur(10px);
            padding: 1rem 1.5rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .logo img {
            height: 40px;
        }

        .logo-text {
            font-size: 1.5rem;
            font-weight: 800;
            color: var(--primary-blue);
        }

        .header-actions {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .notification-btn {
            position: relative;
            background: var(--medium-gray);
            border: none;
            color: var(--text-light);
            font-size: 1.2rem;
            cursor: pointer;
            padding: 0.75rem;
            border-radius: 50%;
            transition: all 0.3s ease;
        }

        .notification-btn:hover {
            background: var(--light-gray);
            color: var(--primary-blue);
        }

        .notification-badge {
            position: absolute;
            top: 0;
            right: 0;
            width: 10px;
            height: 10px;
            background: var(--danger);
            border-radius: 50%;
        }

        .account-section {
            position: relative;
        }

        .account-btn {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            background: var(--medium-gray);
            border: none;
            color: var(--text-light);
            cursor: pointer;
            padding: 0.5rem 1rem;
            border-radius: 2rem;
            transition: all 0.3s ease;
        }

        .account-btn:hover {
            background: var(--light-gray);
        }

        .account-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid var(--primary-blue);
        }

        .account-info {
            display: flex;
            flex-direction: column;
            align-items: flex-start;
        }

        .account-name {
            font-weight: 600;
            font-size: 0.9rem;
        }

        .account-username {
            font-size: 0.8rem;
            color: var(--text-dim);
        }

        .account-dropdown {
            position: absolute;
            top: 100%;
            right: 0;
            margin-top: 0.5rem;
            background: var(--dark-gray);
            backdrop-filter: blur(10px);
            border-radius: 0.75rem;
            box-shadow: 0 10px 25px rgba(0,0,0,0.4);
            min-width: 220px;
            overflow: hidden;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
            transition: all 0.3s ease;
        }

        .account-dropdown.active {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        .dropdown-divider {
            height: 1px;
            background: var(--light-gray);
            margin: 0.5rem 0;
        }

        .dropdown-item {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem 1rem;
            color: var(--text-light);
            text-decoration: none;
            transition: background-color 0.3s;
        }

        .dropdown-item:hover {
            background-color: var(--medium-gray);
        }

        .dropdown-item i {
            font-size: 1.1rem;
            width: 20px;
            text-align: center;
            color: var(--primary-blue);
        }

        /* Bottom Navigation Bar */
        .bottom-navigation {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: var(--dark-gray);
            box-shadow: 0 -2px 10px rgba(0,0,0,0.2);
            z-index: 100;
            padding: 0.75rem 0;
            display: flex;
            justify-content: space-around;
            align-items: center;
        }

        .bottom-nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 0.5rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
            color: var(--text-dim);
            text-decoration: none;
            width: 20%;
        }

        .bottom-nav-item:hover {
            background: var(--medium-gray);
            color: var(--primary-blue);
        }

        .bottom-nav-item.active {
            background: var(--medium-gray);
            color: var(--primary-blue);
        }

        .bottom-nav-icon {
            font-size: 1.5rem;
            margin-bottom: 0.25rem;
        }

        .bottom-nav-text {
            font-size: 0.7rem;
            font-weight: 600;
        }

        /* Right Sidebar Menu */
        .right-sidebar {
            position: fixed;
            top: 0;
            right: -50%; /* Hidden by default - half page width */
            width: 50%; /* Half page width */
            height: 100%;
            background: var(--dark-gray);
            z-index: 1001;
            transition: right 0.4s cubic-bezier(0.25, 0.8, 0.25, 1);
            overflow-y: auto;
            box-shadow: -5px 0 25px rgba(0,0,0,0.4);
        }

        .right-sidebar.active {
            right: 0;
        }

        .sidebar-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 1.5rem;
            border-bottom: 1px solid var(--light-gray);
            position: relative;
            z-index: 2;
            background: var(--dark-gray);
        }

        .sidebar-logo {
            height: 40px;
            filter: drop-shadow(0 2px 4px rgba(0,0,0,0.3));
        }

        .sidebar-close {
            background: var(--medium-gray);
            border: none;
            color: var(--text-light);
            font-size: 1.5rem;
            cursor: pointer;
            padding: 0.5rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
        }

        .sidebar-close:hover {
            background: var(--light-gray);
            transform: rotate(90deg);
        }

        .sidebar-content {
            padding: 1rem 0;
            position: relative;
            z-index: 2;
            background: var(--dark-gray);
            min-height: calc(100% - 73px); /* Subtract header height */
        }

        .nk-menu {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .nk-menu-item {
            margin: 0.25rem 0;
            opacity: 0;
            transform: translateX(20px);
            animation: slideInRight 0.5s forwards;
        }

        /* Stagger animation for menu items */
        .nk-menu-item:nth-child(1) { animation-delay: 0.1s; }
        .nk-menu-item:nth-child(2) { animation-delay: 0.15s; }
        .nk-menu-item:nth-child(3) { animation-delay: 0.2s; }
        .nk-menu-item:nth-child(4) { animation-delay: 0.25s; }
        .nk-menu-item:nth-child(5) { animation-delay: 0.3s; }
        .nk-menu-item:nth-child(6) { animation-delay: 0.35s; }
        .nk-menu-item:nth-child(7) { animation-delay: 0.4s; }
        .nk-menu-item:nth-child(8) { animation-delay: 0.45s; }
        .nk-menu-item:nth-child(9) { animation-delay: 0.5s; }
        .nk-menu-item:nth-child(10) { animation-delay: 0.55s; }
        .nk-menu-item:nth-child(11) { animation-delay: 0.6s; }
        .nk-menu-item:nth-child(12) { animation-delay: 0.65s; }
        .nk-menu-item:nth-child(13) { animation-delay: 0.7s; }
        .nk-menu-item:nth-child(14) { animation-delay: 0.75s; }
        .nk-menu-item:nth-child(15) { animation-delay: 0.8s; }

        @keyframes slideInRight {
            from {
                opacity: 0;
                transform: translateX(20px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        .nk-menu-link {
            display: flex;
            align-items: center;
            padding: 0.9rem 1.5rem;
            color: var(--text-light);
            text-decoration: none;
            transition: all 0.3s ease;
            border-radius: 0.75rem;
            margin: 0 0.75rem;
            position: relative;
            overflow: hidden;
        }

        .nk-menu-link::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 4px;
            height: 100%;
            background: var(--primary-blue);
            transform: scaleY(0);
            transition: transform 0.3s ease;
        }

        .nk-menu-link:hover {
            background: var(--medium-gray);
            transform: translateX(5px);
        }

        .nk-menu-link:hover::before {
            transform: scaleY(1);
        }

        .nk-menu-icon {
            margin-right: 1rem;
            color: var(--primary-blue);
            font-size: 1.2rem;
            width: 24px;
            text-align: center;
            transition: transform 0.3s ease;
        }

        .nk-menu-link:hover .nk-menu-icon {
            transform: scale(1.1);
        }

        .nk-menu-text {
            font-weight: 500;
            font-size: 1rem;
        }

        .nk-menu-heading {
            padding: 0.75rem 1.5rem;
            margin: 1.5rem 0 0.75rem;
            color: var(--text-dim);
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 0.1em;
            position: relative;
        }

        .nk-menu-heading::after {
            content: '';
            position: absolute;
            bottom: -0.5rem;
            left: 1.5rem;
            right: 1.5rem;
            height: 1px;
            background: var(--light-gray);
        }

        .overline-title {
            font-weight: 600;
        }

        .nk-menu-sub {
            list-style: none;
            padding: 0;
            margin: 0.25rem 0 0.25rem 2rem;
            background: var(--black);
            border-radius: 0.75rem;
            overflow: hidden;
            max-height: 0;
            opacity: 0;
            transition: all 0.4s ease;
        }

        .nk-menu-sub.active {
            max-height: 500px;
            opacity: 1;
        }

        .nk-menu-sub .nk-menu-item {
            margin: 0;
            opacity: 1;
            transform: none;
            animation: none;
        }

        .nk-menu-sub .nk-menu-link {
            padding: 0.7rem 1rem 0.7rem 1.5rem;
            font-size: 0.9rem;
            border-radius: 0.5rem;
            margin: 0.25rem 0.75rem;
        }

        .nk-menu-sub .nk-menu-link::before {
            width: 3px;
        }

        .nk-menu-sub .nk-menu-icon {
            font-size: 1rem;
            margin-right: 0.75rem;
        }

        /* Menu toggle icon animation */
        .nk-menu-toggle .nk-menu-icon::after {
            content: '\f107';
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            margin-left: auto;
            transition: transform 0.3s ease;
        }

        .nk-menu-toggle.active .nk-menu-icon::after {
            transform: rotate(180deg);
        }

        /* Overlay for sidebar */
        .sidebar-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.7);
            z-index: 1000;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        .sidebar-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        /* Page Title */
        .page-title {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--text-light);
            margin-bottom: 1.5rem;
            padding: 0 1rem;
        }

        /* Username Header */
        .username-header {
            background: linear-gradient(135deg, var(--dark-gray) 0%, var(--medium-gray) 100%);
            border-radius: 1rem;
            padding: 1.5rem;
            margin-bottom: 1.5rem;
            box-shadow: var(--card-shadow);
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .username-header::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 150px;
            height: 150px;
            background: var(--primary-blue);
            opacity: 0.1;
            border-radius: 50%;
            transform: translate(50px, -50px);
        }

        .username-header::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100px;
            height: 100px;
            background: var(--primary-blue);
            opacity: 0.1;
            border-radius: 50%;
            transform: translate(-30px, 30px);
        }

        .username-icon {
            font-size: 3rem;
            margin-bottom: 1rem;
            color: var(--primary-blue);
            position: relative;
            z-index: 1;
        }

        .username-display {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            color: var(--text-light);
            position: relative;
            z-index: 1;
        }

        .username-label {
            font-size: 1rem;
            opacity: 0.8;
            color: var(--text-dim);
            position: relative;
            z-index: 1;
        }

        /* Tab Navigation */
        .tab-navigation {
            display: flex;
            background: var(--dark-gray);
            border-radius: 0.75rem;
            padding: 0.5rem;
            margin-bottom: 1.5rem;
            overflow-x: auto;
        }

        .tab-nav-item {
            flex: 1;
            text-align: center;
            padding: 0.75rem;
            border-radius: 0.5rem;
            color: var(--text-dim);
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            white-space: nowrap;
        }

        .tab-nav-item:hover {
            background: var(--medium-gray);
            color: var(--text-light);
        }

        .tab-nav-item.active {
            background: var(--primary-blue);
            color: var(--black);
        }

        .tab-nav-item i {
            margin-right: 0.5rem;
        }

        /* Tab Content */
        .tab-content {
            display: none;
        }

        .tab-content.active {
            display: block;
        }

        /* Form Styles */
        .settings-form {
            background: var(--dark-gray);
            border-radius: 1rem;
            padding: 1.5rem;
            box-shadow: var(--card-shadow);
        }

        .form-section-title {
            font-size: 1.2rem;
            font-weight: 700;
            color: var(--text-light);
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .form-section-title i {
            color: var(--primary-blue);
        }

        .form-group {
            margin-bottom: 1.25rem;
        }

        .form-label {
            display: block;
            font-weight: 600;
            margin-bottom: 0.5rem;
            color: var(--text-light);
            font-size: 0.9rem;
        }

        .form-control {
            border: 1px solid var(--border-color);
            border-radius: 0.5rem;
            padding: 0.75rem 1rem;
            font-size: 0.9rem;
            transition: all 0.3s ease;
            background-color: var(--input-bg);
            color: var(--text-light);
            width: 100%;
        }

        .form-control:focus {
            border-color: var(--primary-blue);
            box-shadow: 0 0 0 3px rgba(117, 175, 238, 0.2);
            outline: none;
        }

        .form-control[readonly] {
            background-color: var(--light-gray);
            opacity: 0.7;
        }

        .form-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.25rem;
        }

        .btn-primary {
            background: var(--primary-blue);
            color: var(--black);
            border: none;
            border-radius: 0.5rem;
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            transition: all 0.3s ease;
            cursor: pointer;
        }

        .btn-primary:hover {
            background: var(--dark-blue);
            transform: translateY(-2px);
        }

        .btn-link {
            color: var(--primary-blue);
            text-decoration: none;
            font-weight: 500;
            font-size: 0.85rem;
            transition: color 0.3s ease;
        }

        .btn-link:hover {
            color: var(--dark-blue);
            text-decoration: underline;
        }

        .form-actions {
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            gap: 1rem;
            margin-top: 1rem;
        }

        /* Password Toggle */
        .password-toggle {
            position: absolute;
            right: 1rem;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: var(--text-dim);
            transition: color 0.3s ease;
        }

        .password-toggle:hover {
            color: var(--primary-blue);
        }

        .password-toggle .on, .password-toggle .off {
            position: absolute;
            right: 0;
            top: 0;
        }

        .password-toggle .off {
            display: none;
        }

        .password-toggle.show-password .on {
            display: none;
        }

        .password-toggle.show-password .off {
            display: block;
        }

        /* Form Control with Icon */
        .form-control-wrap {
            position: relative;
        }

        /* Response Message */
        .response {
            margin-bottom: 1.5rem;
        }

        .alert {
            padding: 0.75rem 1.25rem;
            border-radius: 0.5rem;
            margin-bottom: 1rem;
        }

        .alert-success {
            background-color: rgba(76, 175, 80, 0.2);
            border: 1px solid rgba(76, 175, 80, 0.3);
            color: var(--success);
        }

        .alert-danger {
            background-color: rgba(244, 67, 54, 0.2);
            border: 1px solid rgba(244, 67, 54, 0.3);
            color: var(--danger);
        }

        /* Success notification */
        .success-notification {
            position: fixed;
            top: 100px;
            right: 20px;
            background: var(--success);
            color: white;
            padding: 1rem 1.5rem;
            border-radius: 0.5rem;
            box-shadow: var(--card-shadow);
            z-index: 1000;
            display: flex;
            align-items: center;
            gap: 1rem;
            transform: translateX(400px);
            transition: transform 0.3s ease;
            opacity: 0;
        }

        .success-notification.show {
            transform: translateX(0);
            opacity: 1;
        }

        .success-notification i {
            font-size: 1.5rem;
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .header {
                padding: 0.75rem 1rem;
            }
            
            .logo-text {
                font-size: 1.2rem;
            }
            
            .account-info {
                display: none;
            }
            
            .right-sidebar {
                width: 80%; /* 80% width on mobile instead of 50% */
                right: -80%;
            }
            
            .username-display {
                font-size: 1.5rem;
            }
            
            .tab-navigation {
                padding: 0.25rem;
            }
            
            .tab-nav-item {
                padding: 0.5rem;
                font-size: 0.85rem;
            }
            
            .form-row {
                grid-template-columns: 1fr;
            }
            
            .success-notification {
                right: 10px;
                left: 10px;
                transform: translateY(-100px);
            }
            
            .success-notification.show {
                transform: translateY(0);
            }
            
            .bottom-nav-text {
                font-size: 0.6rem;
            }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <div class="logo">
            <img src="/g1.jpg" alt="Gainmart Logo">
            <div class="logo-text">Gainmart</div>
        </div>
        <div class="header-actions">
            <div class="account-section">
                <button class="account-btn" id="accountBtn">
                    <img src="/g1.jpg" alt="Profile" class="account-avatar">
                    <div class="account-info">
                        <span class="account-name"><?php echo $fullname ?></span>
                        <span class="account-username">@<?php echo $username ?></span>
                    </div>
                    <i class="fas fa-chevron-down"></i>
                </button>
                
                <div class="account-dropdown" id="accountDropdown">
                    <a href="settings" class="dropdown-item">
                        <i class="fas fa-cog"></i>
                        <span>Settings</span>
                    </a>
                    <div class="dropdown-divider"></div>
                    <a href="logout" class="dropdown-item">
                        <i class="fas fa-sign-out-alt"></i>
                        <span>Log Out</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Right Sidebar Menu -->
    <div class="right-sidebar" id="rightSidebar">
        <div class="sidebar-header">
            <img src="favicon.png" alt="Logo" class="sidebar-logo">
            <button class="sidebar-close" id="sidebarClose">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <div class="sidebar-content">
            <div class="nk-sidebar-menu" data-simplebar>
                <ul class="nk-menu">
                    <li class="nk-menu-item">
                        <a href="../user/index" class="nk-menu-link">
                            <span class="nk-menu-icon"><i class="fas fa-home"></i></span>
                            <span class="nk-menu-text">Dashboard</span>
                        </a>
                    </li>
                    <li class="nk-menu-item">
                        <a href="user_packages.php" class="nk-menu-link">
                            <span class="nk-menu-icon"><i class="fas fa-box"></i></span>
                            <span class="nk-menu-text">Investment Packages</span>
                        </a>
                    </li>
                    <li class="nk-menu-item">
                        <a href="user_withdrawal.php" class="nk-menu-link">
                            <span class="nk-menu-icon"><i class="fas fa-money-bill-wave"></i></span>
                            <span class="nk-menu-text">Withdraw Funds</span>
                        </a>
                    </li>
                    <li class="nk-menu-item">
                        <a href="referrals" class="nk-menu-link">
                            <span class="nk-menu-icon"><i class="fas fa-users"></i></span>
                            <span class="nk-menu-text">My Referrals</span>
                        </a>
                    </li>
                    <li class="nk-menu-item">
                        <a href="settings" class="nk-menu-link">
                            <span class="nk-menu-icon"><i class="fas fa-cog"></i></span>
                            <span class="nk-menu-text">Account Settings</span>
                        </a>
                    </li>
                    
                    <div class="mt-5"></div>
                </ul>
            </div>
        </div>
    </div>

    <!-- Sidebar Overlay -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <div class="nk-content px-0">
        <div class="container-fluid">
            <div class="nk-content-inner">
                <div class="nk-content-body">
                    <div class="row g-gs">

                        <div class="col-12 px-3 mt-4">
                            <h1 class="page-title">Account Settings</h1>
                        </div>
                        
                        <!-- Username Header -->
                        <div class="col-12">
                            <div class="username-header">
                                <div class="username-icon">
                                    <i class="fas fa-user-circle"></i>
                                </div>
                                <div class="username-display">@<?php echo $username ?></div>
                                <div class="username-label">Your Unique Username</div>
                            </div>
                        </div>
                        
                        <!-- Tab Navigation -->
                        <div class="col-12">
                            <div class="tab-navigation">
                                <div class="tab-nav-item active" data-tab="tab-1">
                                    <i class="fas fa-user"></i>
                                    <span>Account</span>
                                </div>
                                <div class="tab-nav-item" data-tab="tab-2">
                                    <i class="fas fa-university"></i>
                                    <span>Bank</span>
                                </div>
                                <div class="tab-nav-item" data-tab="tab-3">
                                    <i class="fas fa-shield-alt"></i>
                                    <span>Security</span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-12">
                            <div class="response" id="responseMessage"><?php echo $genMsg ?></div>
                        </div>
                        
                        <!-- Tab Content -->
                        <div class="col-12">
                            <!-- Account Tab -->
                            <div class="tab-content active" id="tab-1">
                                <div class="settings-form">
                                    <h4 class="form-section-title">
                                        <i class="fas fa-user-edit"></i>
                                        Edit Profile
                                    </h4>
                                    <form method="POST">
                                        <div class="form-row">
                                            <div class="form-group">
                                                <label for="fullname" class="form-label">Full Name</label>
                                                <div class="form-control-wrap">
                                                    <input type="text" value="<?php echo $fullname ?>" class="form-control" name="fullname" placeholder="Full Name">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="username" class="form-label">Username</label>
                                                <div class="form-control-wrap">
                                                    <input type="text" value="<?php echo $username ?>" readonly class="form-control" name="username" placeholder="Username">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-row">
                                            <div class="form-group">
                                                <label for="email" class="form-label">Email address</label>
                                                <div class="form-control-wrap">
                                                    <input type="email" value="<?php echo $email ?>" readonly class="form-control" name="email" placeholder="Email address">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="phone" class="form-label">Phone</label>
                                                <div class="form-control-wrap">
                                                    <input type="tel" class="form-control" value="<?php echo $phoneNumber ?>" name="phone" placeholder="Phone">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-actions">
                                            <button class="btn-primary" name="updateProfile" type="submit">Update Profile</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            
                            <!-- Bank Tab -->
                            <div class="tab-content" id="tab-2">
                                <div class="settings-form">
                                    <h4 class="form-section-title">
                                        <i class="fas fa-university"></i>
                                        Bank Details
                                    </h4>
                                    <form method="POST">
                                        <div class="form-row">
                                            <div class="form-group">
                                                <label for="bankName" class="form-label">Bank Name</label>
                                                <div class="form-control-wrap">
                                                    <input type="text" class="form-control" value="<?php echo $bankName ?>" name="bankName" placeholder="Bank Name">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="acctName" class="form-label">Account Name</label>
                                                <div class="form-control-wrap">
                                                    <input type="text" class="form-control" value="<?php echo $acctName ?>" name="acctName" placeholder="Account Name">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="acctNum" class="form-label">Account Number</label>
                                            <div class="form-control-wrap">
                                                <input type="text" class="form-control" value="<?php echo $acctNum ?>" name="acctNum" placeholder="Account Number">
                                            </div>
                                        </div>
                                        <div class="form-actions">
                                            <button class="btn-primary" name="saveBankDetails" type="submit">Update Bank</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            
                            <!-- Security Tab -->
                            <div class="tab-content" id="tab-3">
                                <div class="settings-form">
                                    <h4 class="form-section-title">
                                        <i class="fas fa-shield-alt"></i>
                                        Change Password
                                    </h4>
                                    <form method="POST">
                                        <div class="form-row">
                                            <div class="form-group">
                                                <label for="currPsw" class="form-label">Old Password</label>
                                                <div class="form-control-wrap">
                                                    <input type="password" class="form-control" name="currPsw" placeholder="Old Password" id="oldPassword">
                                                    <a class="password-toggle" title="Toggle show/hide password" data-target="oldPassword">
                                                        <em class="on icon ni ni-eye-off"></em>
                                                        <em class="off icon ni ni-eye"></em>
                                                    </a>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="newPsw" class="form-label">New Password</label>
                                                <div class="form-control-wrap">
                                                    <input type="password" class="form-control" name="newPsw" placeholder="New Password" id="newPassword">
                                                    <a class="password-toggle" title="Toggle show/hide password" data-target="newPassword">
                                                        <em class="on icon ni ni-eye-off"></em>
                                                        <em class="off icon ni ni-eye"></em>
                                                    </a>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="confirmPsw" class="form-label">Confirm New Password</label>
                                                <div class="form-control-wrap">
                                                    <input type="password" class="form-control" name="confirmPsw" placeholder="Confirm New Password" id="confirmPassword">
                                                    <a class="password-toggle" title="Toggle show/hide password" data-target="confirmPassword">
                                                        <em class="on icon ni ni-eye-off"></em>
                                                        <em class="off icon ni ni-eye"></em>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-actions">
                                            <button class="btn-primary" name="updatePsw" type="submit">Change Password</button>
                                            <a href="../forgot-password" class="btn-link" target="_blank">Forgot Password?</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bottom Navigation Bar -->
    <div class="bottom-navigation">
        <a href="../user/index" class="bottom-nav-item">
            <i class="fas fa-home bottom-nav-icon"></i>
            <span class="bottom-nav-text">Dashboard</span>
        </a>
        <a href="user_packages.php" class="bottom-nav-item">
            <i class="fas fa-box bottom-nav-icon"></i>
            <span class="bottom-nav-text">Packages</span>
        </a>
        <a href="user_withdrawal.php" class="bottom-nav-item">
            <i class="fas fa-money-bill-wave bottom-nav-icon"></i>
            <span class="bottom-nav-text">Withdraw</span>
        </a>
        <a href="referrals" class="bottom-nav-item">
            <i class="fas fa-users bottom-nav-icon"></i>
            <span class="bottom-nav-text">Referrals</span>
        </a>
        <a href="settings" class="bottom-nav-item active">
            <i class="fas fa-cog bottom-nav-icon"></i>
            <span class="bottom-nav-text">Settings</span>
        </a>
    </div>

    <!-- Success Notification -->
    <div class="success-notification" id="successNotification">
        <i class="fas fa-check-circle"></i>
        <div>
            <div class="notification-title">Update Successful!</div>
            <div class="notification-message">Your information has been updated successfully.</div>
        </div>
    </div>

    <script>
        // Account dropdown functionality
        document.addEventListener('DOMContentLoaded', function() {
            const accountBtn = document.getElementById('accountBtn');
            const accountDropdown = document.getElementById('accountDropdown');
            
            if (accountBtn && accountDropdown) {
                accountBtn.addEventListener('click', function(e) {
                    e.stopPropagation();
                    accountDropdown.classList.toggle('active');
                });
                
                // Close dropdown when clicking outside
                document.addEventListener('click', function() {
                    accountDropdown.classList.remove('active');
                });
                
                // Prevent dropdown from closing when clicking inside it
                accountDropdown.addEventListener('click', function(e) {
                    e.stopPropagation();
                });
            }
            
            // Right sidebar functionality
            const hamburgerBtn = document.getElementById('hamburgerBtn');
            const rightSidebar = document.getElementById('rightSidebar');
            const sidebarClose = document.getElementById('sidebarClose');
            const sidebarOverlay = document.getElementById('sidebarOverlay');
            
            if (hamburgerBtn && rightSidebar && sidebarClose && sidebarOverlay) {
                // Open sidebar when hamburger is clicked
                hamburgerBtn.addEventListener('click', function() {
                    rightSidebar.classList.add('active');
                    sidebarOverlay.classList.add('active');
                    document.body.style.overflow = 'hidden'; // Prevent body scroll when sidebar is open
                    
                    // Reset animations when opening
                    const menuItems = rightSidebar.querySelectorAll('.nk-menu-item');
                    menuItems.forEach(item => {
                        item.style.animation = 'none';
                        item.offsetHeight; // Trigger reflow
                        item.style.animation = null;
                    });
                });
                
                // Close sidebar when close button is clicked
                sidebarClose.addEventListener('click', function() {
                    rightSidebar.classList.remove('active');
                    sidebarOverlay.classList.remove('active');
                    document.body.style.overflow = ''; // Restore body scroll
                });
                
                // Close sidebar when overlay is clicked
                sidebarOverlay.addEventListener('click', function() {
                    rightSidebar.classList.remove('active');
                    sidebarOverlay.classList.remove('active');
                    document.body.style.overflow = ''; // Restore body scroll
                });
                
                // Handle submenu toggles
                const menuToggles = document.querySelectorAll('.nk-menu-toggle');
                menuToggles.forEach(toggle => {
                    toggle.addEventListener('click', function(e) {
                        e.preventDefault();
                        const parentItem = this.parentElement;
                        const submenu = parentItem.querySelector('.nk-menu-sub');
                        
                        if (submenu) {
                            submenu.classList.toggle('active');
                            this.classList.toggle('active');
                        }
                    });
                });
            }
            
            // Set active navigation item based on current page
            const currentPath = window.location.pathname;
            const navItems = document.querySelectorAll('.bottom-nav-item');
            
            navItems.forEach(item => {
                const itemPath = item.getAttribute('href');
                if (currentPath.includes(itemPath)) {
                    item.classList.add('active');
                } else {
                    item.classList.remove('active');
                }
            });
            
            // Tab functionality
            const tabNavItems = document.querySelectorAll('.tab-nav-item');
            const tabContents = document.querySelectorAll('.tab-content');
            
            tabNavItems.forEach(item => {
                item.addEventListener('click', function() {
                    const tabId = this.getAttribute('data-tab');
                    
                    // Remove active class from all tabs and contents
                    tabNavItems.forEach(navItem => {
                        navItem.classList.remove('active');
                    });
                    
                    tabContents.forEach(content => {
                        content.classList.remove('active');
                    });
                    
                    // Add active class to clicked tab and corresponding content
                    this.classList.add('active');
                    document.getElementById(tabId).classList.add('active');
                });
            });
            
            // Password toggle functionality
            const passwordToggles = document.querySelectorAll('.password-toggle');
            
            passwordToggles.forEach(toggle => {
                toggle.addEventListener('click', function() {
                    const targetId = this.getAttribute('data-target');
                    const targetInput = document.getElementById(targetId);
                    
                    if (targetInput.type === 'password') {
                        targetInput.type = 'text';
                        this.classList.add('show-password');
                    } else {
                        targetInput.type = 'password';
                        this.classList.remove('show-password');
                    }
                });
            });
            
            // Check for success message in URL parameters
            const urlParams = new URLSearchParams(window.location.search);
            const success = urlParams.get('success');
            
            if (success === '1') {
                // Show success notification
                const successNotification = document.getElementById('successNotification');
                successNotification.classList.add('show');
                
                // Hide notification after 3 seconds
                setTimeout(() => {
                    successNotification.classList.remove('show');
                }, 3000);
                
                // Clean URL parameters
                const cleanUrl = window.location.protocol + "//" + window.location.host + window.location.pathname;
                window.history.replaceState({}, document.title, cleanUrl);
            }
        });
    </script>
</body>
</html>