const spinWheel = document.getElementById("spinWheel");
const spinBtn = document.getElementById("spin_btn");
const text = document.getElementById( "text" );

const spinValues = [
  { minDegree: 61, maxDegree: 90, value: 500 },
  { minDegree: 31, maxDegree: 60, value: 0 },
  { minDegree: 0, maxDegree: 30, value: 1000 },
  { minDegree: 331, maxDegree: 360, value: 0 },
  { minDegree: 301, maxDegree: 330, value: 200 },
  { minDegree: 271, maxDegree: 300, value: 0 },
  { minDegree: 241, maxDegree: 270, value: 500 },
  { minDegree: 211, maxDegree: 240, value: 0 },
  { minDegree: 181, maxDegree: 210, value: 1000 },
  { minDegree: 151, maxDegree: 180, value: 0 },
  { minDegree: 121, maxDegree: 150, value: 200 },
  { minDegree: 91, maxDegree: 120, value: 0 },
];
const size = [3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3];
var spinColors = [
  "#1a16a6",
  "#d4d3f0",
  "#1a16a6",
  "#d4d3f0",
  "#1a16a6",
  "#d4d3f0",
  "#1a16a6",
  "#d4d3f0",
  "#1a16a6",
  "#d4d3f0",
  "#1a16a6",
  "#d4d3f0",
];

let spinChart = new Chart( spinWheel, {
  plugins: [ChartDataLabels],
  type: "pie",
  data: {
    labels: [500, 0, 1000, 0, 200, 0, 500, 0, 1000, 0, 200, 0],
    datasets: [
      {
        backgroundColor: spinColors,
        data: size,
      },
    ],
  },
  options: {
    responsive: true,
    animation: { duration: 0 },
    plugins: {
      tooltip: false,
      legend: {
        display: false,
      },
      datalabels: {
        rotation: 90,
        color: "#ffffff",
        formatter: (_, context) => context.chart.data.labels[context.dataIndex],
        font: { size: 12, family: "MTN Brighter Sans" },
      },
    },
  },
  font: {
    family: "MTN Brighter Sans",
  },
});

const generateValue = (angleValue) => {
  for (let i of spinValues) {
    if (angleValue >= i.minDegree && angleValue <= i.maxDegree) {
      if (i.value === 0) {
        text.innerHTML = "<p>Sorry, you won ₦0 😔</p>";
      } else {
        text.innerHTML = `<p>Congratulations, You Have Won ₦${i.value} ️🤗💰!</p>`;
      }
      gameOver(i.value);
      spinBtn.disabled = false;
      break;
    }
  }
};

let count = 0;
let resultValue = 101;
spinBtn.addEventListener("click", () => {
  spinBtn.disabled = true;
  text.innerHTML = `<p>Best Of Luck!</p>`;
  let randomDegree = Math.floor(Math.random() * (355 - 0 + 1) + 0);
  let rotationInterval = window.setInterval(() => {
    spinChart.options.rotation = spinChart.options.rotation + resultValue;
    spinChart.update();
    if (spinChart.options.rotation >= 360) {
      count += 1;
      resultValue -= 5;
      spinChart.options.rotation = 0;
    } else if (count > 15 && spinChart.options.rotation == randomDegree) {
      generateValue(randomDegree);
      clearInterval(rotationInterval);
      count = 0;
      resultValue = 101;
    }
  }, 10);
});

function gameOver(score){
    $.ajax({
        url : "actions/spin",
        type : "POST",
        data : {
            "spin" : "spin",
            "score" :score
        },
        success:function(response){
            $(".genMsg").html(response);
        }
    })
}