<?php
require $_SERVER['DOCUMENT_ROOT'] . "/stream.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/includes/generalinclude.php";
require $_SERVER['DOCUMENT_ROOT'] . "$stream/user/includes/generalinclude.php";
$ptitle = "Vendor Dashboard";
if($role != "vendor"){
    header("location:$stream/login");
    exit;
}
$sql=$link->prepare("SELECT * FROM coupons WHERE vendor=?");
$sql->bind_param("s", $username);
$sql->execute();
$result=$sql->get_result();
$totalCoupon=$result->num_rows;
$sql=$link->prepare("SELECT * FROM coupons WHERE vendor=? AND status='used' ");
$sql->bind_param("s", $username);
$sql->execute();
$result=$sql->get_result();
$usedCoupon=$result->num_rows;
$sql=$link->prepare("SELECT * FROM coupons WHERE vendor=? AND status='active' ");
$sql->bind_param("s", $username);
$sql->execute();
$result=$sql->get_result();
$activeCoupon=$result->num_rows;

include "includes/header.php"
?>
<style>
    :root {
        --primary-red: #ff3131;
        --dark-red: #cc0000;
        --black: #000000;
        --white: #ffffff;
        --light-gray: #f8f9fa;
        --medium-gray: #e9ecef;
    }
    
    body {
        background-color: var(--light-gray);
        color: var(--black);
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    
    .nk-content {
        padding: 1.5rem 0;
    }
    
    .card {
        border: none;
        border-radius: 12px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        margin-bottom: 1.5rem;
        overflow: hidden;
        background-color: var(--white);
    }
    
    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.12);
    }
    
    .card-body {
        padding: 1.5rem;
    }
    
    .card-title {
        color: var(--black);
        font-weight: 700;
        margin-bottom: 1rem;
    }
    
    .card-title h6 {
        font-size: 1rem;
        margin: 0;
    }
    
    .card-title-group {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }
    
    .media {
        display: flex;
        align-items: center;
    }
    
    .media-circle {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .text-bg-primary-soft {
        background-color: rgba(255, 49, 49, 0.1);
        color: var(--primary-red);
    }
    
    .icon {
        font-size: 1.2rem;
    }
    
    .amount {
        font-weight: 700;
        font-size: 1.5rem;
        color: var(--primary-red);
    }
    
    .fs-12 {
        font-size: 12px;
    }
    .fs-14 {
        font-size: 14px;
    }
    
    .status {
        padding: 4px 10px;
        border-radius: 20px;
        color: var(--white);
        font-weight: 600;
        font-size: 0.8rem;
        display: inline-block;
    }
    
    .bg-success {
        background-color: #28a745;
    }
    
    .bg-danger {
        background-color: #dc3545;
    }
    
    .coupon {
        white-space: nowrap;
        font-weight: 600;
    }
    
    .bg-primary-soft {
        background-color: rgba(255, 49, 49, 0.1) !important;
    }
    
    .table {
        color: var(--black);
        margin-bottom: 0;
    }
    
    .table thead th {
        color: var(--black);
        font-weight: 600;
        border-bottom: 2px solid var(--medium-gray);
        padding: 1rem;
        background-color: var(--white);
    }
    
    .table tbody tr {
        border-bottom: 1px solid var(--medium-gray);
        transition: background-color 0.3s ease;
        background-color: var(--white);
    }
    
    .table tbody tr:hover {
        background-color: rgba(255, 49, 49, 0.05);
    }
    
    .table tbody tr:last-child {
        border-bottom: none;
    }
    
    .table tbody td {
        padding: 1rem;
    }
    
    .table-responsive {
        border-radius: 0 0 12px 12px;
    }
    
    .pointer {
        cursor: pointer;
    }
    
    .vendor-header {
        margin-bottom: 2rem;
    }
    
    .vendor-header h5 {
        font-size: 1.5rem;
        color: var(--black);
        font-weight: 700;
    }
    
    .stats-card {
        position: relative;
        overflow: hidden;
    }
    
    .stats-card::before {
        content: '';
        position: absolute;
        top: 0;
        right: 0;
        width: 80px;
        height: 80px;
        background: rgba(255, 49, 49, 0.05);
        border-radius: 50%;
        transform: translate(20px, -20px);
    }
    
    .stats-card .media {
        position: relative;
        z-index: 1;
    }
    
    .no-data {
        text-align: center;
        padding: 2rem;
        color: var(--medium-gray);
    }
    
    .no-data i {
        font-size: 2rem;
        margin-bottom: 0.5rem;
        display: block;
    }
    
    @media (max-width: 768px) {
        .nk-content {
            padding: 1rem 0;
        }
        
        .card-body {
            padding: 1.25rem;
        }
        
        .table thead th, .table tbody td {
            padding: 0.75rem 0.5rem;
        }
        
        .amount {
            font-size: 1.2rem;
        }
    }
</style>

<div class="nk-content px-0">
    <div class="container-fluid">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="vendor-header col-12 px-3">
                    <h5>Hello <?php echo $username ?></h5>
                </div>
                
                <div class="row g-gs">
                    <!-- Active Coupons Card -->
                    <div class="col-6 col-md-3 px-2">
                        <div class="card h-100 stats-card">
                            <div class="card-body">
                                <div class="card-title-group align-items-start">
                                    <div class="card-title">
                                        <h6 class="title">Active Coupons</h6>
                                    </div>
                                    <div class="media media-middle media-circle media-sm text-bg-primary-soft">
                                        <em class="icon icon-md ni ni-tag-alt"></em>
                                    </div>
                                </div>
                                <div class="mt-2">
                                    <div class="amount fs-14"><?php echo $activeCoupon ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Used Coupons Card -->
                    <div class="col-6 col-md-3 px-2">
                        <div class="card h-100 stats-card">
                            <div class="card-body">
                                <div class="card-title-group align-items-start">
                                    <div class="card-title">
                                        <h6 class="title">Used Coupons</h6>
                                    </div>
                                    <div class="media media-middle media-circle media-sm text-bg-primary-soft">
                                        <em class="icon icon-md ni ni-check-circle"></em>
                                    </div>
                                </div>
                                <div class="mt-2">
                                    <div class="amount fs-14"><?php echo $usedCoupon ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Total Coupons Card -->
                    <div class="col-6 col-md-3 px-2">
                        <div class="card h-100 stats-card">
                            <div class="card-body">
                                <div class="card-title-group align-items-start">
                                    <div class="card-title">
                                        <h6 class="title">Total Coupons</h6>
                                    </div>
                                    <div class="media media-middle media-circle media-sm text-bg-primary-soft">
                                        <em class="icon icon-md ni ni-file-text"></em>
                                    </div>
                                </div>
                                <div class="mt-2">
                                    <div class="amount fs-14"><?php echo $totalCoupon ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Available Coupons Card -->
                    <div class="col-6 col-md-3 px-2">
                        <div class="card h-100 stats-card">
                            <div class="card-body">
                                <div class="card-title-group align-items-start">
                                    <div class="card-title">
                                        <h6 class="title">Available</h6>
                                    </div>
                                    <div class="media media-middle media-circle media-sm text-bg-primary-soft">
                                        <em class="icon icon-md ni ni-coins"></em>
                                    </div>
                                </div>
                                <div class="mt-2">
                                    <div class="amount fs-14"><?php echo $activeCoupon ?></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Coupon Codes Table -->
                    <div class="col-12">
                        <div class="card h-100 bg-primary-soft">
                            <div class="flex-grow-0 mt-2 px-2">
                                <div class="card-title-group">
                                    <div class="card-title">
                                        <h5 class="alert-heading mb-0 text-primary" style="font-weight: 600">
                                            <em class="icon ni ni-tag-alt me-2"></em>
                                            Available Coupon Codes
                                        </h5>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body px-0">
                                <div class="table-responsive">
                                    <table class="table table-middle mb-0">
                                        <thead>
                                            <tr>
                                                <th><a><span class="overline-title text-center text-primary">Coupon</span></a></th>
                                                <th><a><span class="overline-title text-center text-primary">Package</span></a></th>
                                                <th><a><span class="overline-title text-center text-primary">Status</span></a></th>
                                                <th><a><span class="overline-title text-center text-primary">Used By</span></a></th>
                                                <th><a><span class="overline-title text-center text-primary">Date</span></a></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php 
                                            $sql=$link->prepare("SELECT * FROM coupons WHERE vendor=? ORDER BY id DESC");
                                            $sql->bind_param("s", $username);
                                            $sql->execute();
                                            $result=$sql->get_result();
                                            
                                            $numrow=$result->num_rows;
                                            if($numrow > 0){
                                                $id=0;
                                                while($row=$result->fetch_assoc()){
                                                    $id++;
                                                    $coupon=$row['coupon'];
                                                    $date=$row['date'];
                                                    $status=$row['status'];
                                                    $type=$row['type'];
                                                    if($status == "used"){
                                                        $statusColor="danger";
                                                    }
                                                    else{
                                                        $statusColor="success";
                                                    }
                                                    if($type == "plan_a"){
                                                            $plantype="X-Gold Lite";
                                                    }
                                                    else if($type == "plan_b"){
                                                            $plantype="X-Gold Smart";
                                                    }
                                                    $sql_user=$link->prepare("SELECT * FROM users WHERE coupon=?");
                                                    $sql_user->bind_param("s", $coupon);
                                                    $sql_user->execute();
                                                    $result_user=$sql_user->get_result();
                                                    $row_user=$result_user->fetch_assoc();
                                                    $numrow_user=$result_user->num_rows;
                                                    $usedBy="";
                                                    if($numrow_user == 1){
                                                        $usedBy=$row_user['username'];
                                                    }
                                            ?>
                                                    <tr class="pointer">
                                                        <td class="tb-col">
                                                            <div class="media-text"><span class="title coupon"><?php echo $coupon ?></span></div>
                                                        </td>
                                                        <td class="tb-col">
                                                            <div class="media-text"><span class="title"><?php echo $plantype ?></span></div>
                                                        </td>
                                                        <td class="tb-col">
                                                            <div class="media-text">
                                                                <span class="status bg-<?php echo $statusColor ?>"><?php echo $status ?></span>
                                                            </div>
                                                        </td>
                                                        <td class="tb-col">
                                                            <div class="media-text">
                                                                <span class="title"><?php echo $usedBy ?></span>
                                                            </div>
                                                        </td>
                                                        <td class="tb-col">
                                                            <div class="media-text">
                                                                <span class="title"><?php echo $date ?></span>
                                                            </div>
                                                        </td>
                                                    </tr>
                                            <?php }
                                            } else { ?>
                                                <tr>
                                                    <td colspan="5" class="no-data">
                                                        <em class="icon ni ni-tag-alt"></em>
                                                        <p>No coupon codes available</p>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
    </div>
</div>
<?php include "includes/footer.php" ?>